/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.com.google.common.collect;

import com.netflix.nebula.lint.com.google.common.annotations.GwtCompatible;
import com.netflix.nebula.lint.com.google.common.base.Preconditions;
import com.netflix.nebula.lint.com.google.common.collect.Multiset;
import com.netflix.nebula.lint.com.google.common.collect.ParametricNullness;
import com.netflix.nebula.lint.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.netflix.nebula.lint.com.google.errorprone.annotations.CompatibleWith;
import com.netflix.nebula.lint.com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;

@DoNotMock(value="Use ImmutableMultimap, HashMultimap, or another implementation")
@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(@CompatibleWith(value="K") @Nullable Object var1);

    public boolean containsValue(@CompatibleWith(value="V") @Nullable Object var1);

    public boolean containsEntry(@CompatibleWith(value="K") @Nullable Object var1, @CompatibleWith(value="V") @Nullable Object var2);

    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K var1, @ParametricNullness V var2);

    @CanIgnoreReturnValue
    public boolean remove(@CompatibleWith(value="K") @Nullable Object var1, @CompatibleWith(value="V") @Nullable Object var2);

    @CanIgnoreReturnValue
    public boolean putAll(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@ParametricNullness K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public Collection<V> removeAll(@CompatibleWith(value="K") @Nullable Object var1);

    public void clear();

    public Collection<V> get(@ParametricNullness K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(@Nullable Object var1);

    public int hashCode();
}

