/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Query;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.FactoryExpressionTransformer;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.query.ListSubQuery;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateSQLQuery<Q extends AbstractHibernateSQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateSQLQuery.class);
    protected Boolean cacheable;
    protected Boolean readOnly;
    protected String cacheRegion;
    @Nullable
    private Map<Object, String> constants;
    @Nullable
    private List<Path<?>> entityPaths;
    protected int fetchSize = 0;
    private final SessionHolder session;
    protected final SQLTemplates templates;
    protected int timeout = 0;
    @Nullable
    protected SubQueryExpression<?>[] union;
    private boolean unionAll;

    public AbstractHibernateSQLQuery(Session session, SQLTemplates sqlTemplates) {
        this(new DefaultSessionHolder(session), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(StatelessSession session, SQLTemplates sqlTemplates) {
        this(new StatelessSessionHolder(session), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(SessionHolder session, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.templates = sqlTemplates;
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.templates);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
                throw new IllegalArgumentException("No joins given");
            }
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        this.entityPaths = serializer.getEntityPaths();
        return serializer.toString();
    }

    public org.hibernate.Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addToProjection(args);
        return this.createQuery(this.toQueryString());
    }

    private org.hibernate.Query createQuery(String queryString) {
        this.logQuery(queryString);
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((org.hibernate.Query)query, this.constants, this.queryMixin.getMetadata().getParams());
        for (Path<?> path : this.entityPaths) {
            query.addEntity(path.toString(), path.getType());
        }
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.size() == 1 && projection.get(0) instanceof FactoryExpression) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection.get(0)));
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    public List<Object[]> list(Expression<?>[] projection) {
        org.hibernate.Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        org.hibernate.Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addToProjection(new Expression[]{projection});
        org.hibernate.Query query = this.createQuery(this.toCountRowsString());
        long total = ((Number)query.uniqueResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List list = query.list();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.entityPaths = null;
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public Object[] uniqueResult(Expression<?>[] args) {
        org.hibernate.Query query = this.createQuery(args);
        Object obj = this.uniqueResult(query);
        if (obj != null) {
            Object[] objectArray;
            if (obj.getClass().isArray()) {
                objectArray = (Object[])obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            }
            return objectArray;
        }
        return null;
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        org.hibernate.Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(org.hibernate.Query query) {
        this.reset();
        try {
            return query.uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)false)))));
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)false)))));
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)true)))));
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from(UnionUtils.combineUnion(sq, alias, (SQLTemplates)this.templates, (boolean)true)))));
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = sq;
        return new UnionImpl((Query)this, this.union[0].getMetadata().getProjection());
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }
}

