/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Objects;
import com.mysema.query.types.Constant;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;

public final class HashCodeVisitor
implements Visitor<Integer, Void> {
    public static final HashCodeVisitor DEFAULT = new HashCodeVisitor();

    private HashCodeVisitor() {
    }

    @Override
    public Integer visit(Constant<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getConstant()});
    }

    @Override
    public Integer visit(FactoryExpression<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getType(), expr.getArgs()});
    }

    @Override
    public Integer visit(Operation<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getOperator(), expr.getArgs()});
    }

    @Override
    public Integer visit(ParamExpression<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getName()});
    }

    @Override
    public Integer visit(Path<?> expr, Void context) {
        PathMetadata<?> md = expr.getMetadata();
        return Objects.hashCode((Object[])new Object[]{md.getPathType(), md.getParent(), md.getExpression()});
    }

    @Override
    public Integer visit(SubQueryExpression<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getMetadata()});
    }

    @Override
    public Integer visit(TemplateExpression<?> expr, Void context) {
        return Objects.hashCode((Object[])new Object[]{expr.getTemplate(), expr.getArgs()});
    }
}

