/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class LazyMap<K, V>
implements Map<K, V> {
    private final Map<K, Supplier<V>> suppliers;
    private final Function<K, V> alternative;

    public LazyMap() {
        this.suppliers = new HashMap<K, Supplier<V>>();
        this.alternative = k -> null;
    }

    public LazyMap(int initialCapacity) {
        this.suppliers = new HashMap<K, Supplier<V>>(initialCapacity);
        this.alternative = k -> null;
    }

    public LazyMap(Function<K, V> alternative) {
        this.suppliers = new HashMap<K, Supplier<V>>();
        this.alternative = alternative;
    }

    public LazyMap(int initialCapacity, Function<K, V> alternative) {
        this.suppliers = new HashMap<K, Supplier<V>>(initialCapacity);
        this.alternative = alternative;
    }

    public Supplier<V> getSupplier(K key) {
        return this.suppliers.get(key);
    }

    public void putSupplier(K key, Supplier<V> supplier) {
        this.suppliers.put(key, supplier);
    }

    @Override
    public V get(Object key) {
        Supplier<V> supplier = this.suppliers.get(key);
        return supplier == null ? this.alternative.apply(key) : supplier.get();
    }

    @Override
    public V put(K key, V value) {
        this.suppliers.put(key, () -> value);
        return null;
    }

    @Override
    public V remove(Object key) {
        this.suppliers.remove(key);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.suppliers.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.suppliers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.suppliers.values().stream().anyMatch(supplier -> Objects.equals(supplier.get(), value));
    }

    @Override
    public int size() {
        return this.suppliers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.suppliers.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.suppliers.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.suppliers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.get(e.getKey()))).entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.suppliers.values().stream().map(Supplier::get).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.suppliers.hashCode();
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

