/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyIdentifier;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class KeyBundle {
    @JsonProperty(value="key")
    private JsonWebKey key = new JsonWebKey();
    @JsonProperty(value="attributes")
    private KeyAttributes attributes = new KeyAttributes();
    @JsonProperty(value="tags")
    private Map<String, String> tags;

    public JsonWebKey getKey() {
        return this.key;
    }

    public void setKey(JsonWebKey keyValue) {
        this.key = keyValue;
    }

    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(KeyAttributes attributesValue) {
        this.attributes = attributesValue;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tagsValue) {
        this.tags = tagsValue;
    }

    public KeyIdentifier getKeyIdentifier() {
        if (this.key == null || this.key.getKid() == null || this.key.getKid().length() == 0) {
            return null;
        }
        return new KeyIdentifier(this.key.getKid());
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

