/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.spring.boot.startup;

import com.maciejwalkowiak.spring.boot.startup.Event;
import com.maciejwalkowiak.spring.boot.startup.TagsResolver;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;

class TimelineFactory {
    private final BufferingApplicationStartup applicationStartup;
    private final TagsResolver tagsResolver;

    public TimelineFactory(BufferingApplicationStartup applicationStartup, TagsResolver resolver) {
        this.applicationStartup = applicationStartup;
        this.tagsResolver = resolver;
    }

    public List<Event> getTimeline() {
        List timelineEvents = this.applicationStartup.getBufferedTimeline().getEvents().stream().sorted(Collections.reverseOrder(Comparator.comparingLong(o -> o.getDuration().toMillis()))).collect(Collectors.toList());
        return timelineEvents.stream().map(it -> Event.create(it, timelineEvents, this.tagsResolver)).sorted(Collections.reverseOrder(Comparator.comparingLong(Event::getValue))).filter(it -> it.getParentId() == null).collect(Collectors.toList());
    }
}

