/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.spring.boot.startup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maciejwalkowiak.spring.boot.startup.Event;
import com.maciejwalkowiak.spring.boot.startup.TimelineFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

class ReportRenderer {
    private final TimelineFactory timelineFactory;
    private final ResourceLoader resourceLoader;
    private final ObjectMapper mapper = new ObjectMapper();

    public ReportRenderer(TimelineFactory timelineFactory, ResourceLoader resourceLoader) {
        this.timelineFactory = timelineFactory;
        this.resourceLoader = resourceLoader;
    }

    String render() {
        Resource resource = this.resourceLoader.getResource("classpath:/com/maciejwalkowiak/spring/boot/startup/startup-analysis.html");
        try {
            String template = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            return template.replace("%events%", this.serialize(this.timelineFactory.getTimeline()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String serialize(List<Event> events) {
        try {
            return this.mapper.writeValueAsString(events);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

