/*
 * Decompiled with CFR 0.152.
 */
package com.kosprov.jargon2.nativeri.backend;

import argon2.Argon2Library;
import argon2.Argon2_Context;
import com.kosprov.jargon2.api.Jargon2;
import com.kosprov.jargon2.nativeri.backend.NativeInvocationJargon2BackendException;
import com.kosprov.jargon2.spi.Jargon2Backend;
import com.kosprov.jargon2.spi.Jargon2BackendException;
import com.sun.jna.Memory;
import java.util.Arrays;
import java.util.Map;

public class NativeRiJargon2Backend
implements Jargon2Backend {
    private static final char[] encodeMapping = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] decodeMapping = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] rawHash(Jargon2.Type type, Jargon2.Version version, int memoryCost, int timeCost, int lanes, int threads, int hashLength, byte[] secret, byte[] ad, byte[] salt, byte[] password, Map<String, Object> options) {
        if (hashLength < 4) {
            throw new Jargon2BackendException("Hash length must be greater or equal to 4");
        }
        if (salt == null || salt.length < 8) {
            throw new Jargon2BackendException("Salt must not be null and its length must be greater or equal to 8");
        }
        if (password == null || password.length == 0) {
            throw new Jargon2BackendException("Password must not be null or empty");
        }
        if (lanes < 1) {
            throw new Jargon2BackendException("Lanes must be greater or equal to 1");
        }
        if (lanes > 0xFFFFFF) {
            throw new Jargon2BackendException("Lanes must be less or equal to 16777215");
        }
        if (threads < 1) {
            throw new Jargon2BackendException("Threads must be greater or equal to 1");
        }
        if (threads > 0xFFFFFF) {
            throw new Jargon2BackendException("Threads must be less or equal to 16777215");
        }
        if (threads > lanes) {
            threads = lanes;
        }
        if (memoryCost < 8) {
            throw new Jargon2BackendException("Memory cost must be greater or equal to 8");
        }
        if (memoryCost < 8 * lanes) {
            throw new Jargon2BackendException("Memory cost must be greater or equal to 8 * lanes");
        }
        if (timeCost < 1) {
            throw new Jargon2BackendException("Time cost must be greater or equal to 1");
        }
        DisposableMemory passwordMemory = null;
        DisposableMemory saltMemory = null;
        DisposableMemory secretMemory = null;
        DisposableMemory adMemory = null;
        DisposableMemory outputMemory = null;
        try {
            passwordMemory = this.copyToMemory(password);
            saltMemory = this.copyToMemory(salt);
            secretMemory = this.copyToMemory(secret);
            adMemory = this.copyToMemory(ad);
            outputMemory = this.createMemory(hashLength);
            Argon2_Context.ByReference ctx = new Argon2_Context.ByReference();
            ctx.out = outputMemory;
            ctx.outlen = hashLength;
            ctx.pwd = passwordMemory;
            ctx.pwdlen = password.length;
            ctx.salt = saltMemory;
            ctx.saltlen = salt.length;
            ctx.secret = secretMemory;
            ctx.secretlen = secret != null ? secret.length : 0;
            ctx.ad = adMemory;
            ctx.adlen = ad != null ? ad.length : 0;
            ctx.t_cost = timeCost;
            ctx.m_cost = memoryCost;
            ctx.lanes = lanes;
            ctx.threads = threads;
            ctx.version = this.convertVersion(version);
            ctx.allocate_cbk = null;
            ctx.free_cbk = null;
            ctx.flags = 0;
            int argon2Type = this.convertType(type);
            int status = Argon2Library.INSTANCE.argon2_ctx(ctx, argon2Type);
            if (status != 0) {
                String errorMessage = Argon2Library.INSTANCE.argon2_error_message(status);
                throw new NativeInvocationJargon2BackendException(status, errorMessage);
            }
            byte[] hash = new byte[hashLength];
            outputMemory.read(0L, hash, 0, hashLength);
            byte[] byArray = hash;
            return byArray;
        }
        finally {
            if (passwordMemory != null) {
                passwordMemory.clear(password.length);
                passwordMemory.dispose();
            }
            if (saltMemory != null) {
                saltMemory.dispose();
            }
            if (secretMemory != null) {
                secretMemory.clear(secret.length);
                secretMemory.dispose();
            }
            if (adMemory != null) {
                adMemory.dispose();
            }
            if (outputMemory != null) {
                outputMemory.clear(hashLength);
                outputMemory.dispose();
            }
        }
    }

    public String encodedHash(Jargon2.Type type, Jargon2.Version version, int memoryCost, int timeCost, int lanes, int threads, int hashLength, byte[] secret, byte[] ad, byte[] salt, byte[] password, Map<String, Object> options) {
        byte[] rawHash = this.rawHash(type, version, memoryCost, timeCost, lanes, threads, hashLength, secret, ad, salt, password, options);
        try {
            String string = this.encodeString(type, version, timeCost, memoryCost, lanes, salt, rawHash);
            return string;
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Failed to encode hash", (Throwable)e);
        }
        finally {
            Arrays.fill(rawHash, (byte)0);
        }
    }

    public boolean verifyEncoded(String encodedHash, int threads, byte[] secret, byte[] ad, byte[] password, Map<String, Object> options) {
        if (encodedHash == null) {
            throw new Jargon2BackendException("Encoded hash cannot be null");
        }
        if ("".equals(encodedHash.trim())) {
            throw new Jargon2BackendException("Encoded hash cannot be empty");
        }
        DecodedHash decoded = this.decodeString(encodedHash);
        int lanes = decoded.parallelism;
        if (threads == -1) {
            threads = decoded.parallelism;
        }
        return this.verifyRaw(decoded.type, decoded.version, decoded.memoryCost, decoded.timeCost, lanes, threads, decoded.hash, secret, ad, decoded.salt, password, options);
    }

    public boolean verifyRaw(Jargon2.Type type, Jargon2.Version version, int memoryCost, int timeCost, int lanes, int threads, byte[] rawHash, byte[] secret, byte[] ad, byte[] salt, byte[] password, Map<String, Object> options) {
        byte[] newHash = this.rawHash(type, version, memoryCost, timeCost, lanes, threads, rawHash.length, secret, ad, salt, password, options);
        return Arrays.equals(rawHash, newHash);
    }

    private DecodedHash decodeString(String encodedHash) {
        DecodedHash decoded = new DecodedHash();
        String[] parts = this.split(encodedHash, '$', 5);
        if (parts.length != 4 && parts.length != 5) {
            throw new Jargon2BackendException("Encoded hash is not properly formatted");
        }
        int typeIndex = 0;
        int versionIndex = 1;
        int optionsIndex = parts.length == 4 ? 1 : 2;
        int saltIndex = parts.length == 4 ? 2 : 3;
        int hashIndex = parts.length == 4 ? 3 : 4;
        String typeOpt = parts[typeIndex];
        decoded.type = this.convertType(typeOpt);
        if (parts.length == 5) {
            String versionOpt = parts[versionIndex];
            if (!versionOpt.startsWith("v=") || versionOpt.length() < 4) {
                throw new Jargon2BackendException("Encoded hash is not properly formatted");
            }
            decoded.version = this.convertVersion(versionOpt.substring(2));
        } else {
            decoded.version = Jargon2.Version.V10;
        }
        this.parseOptions(parts[optionsIndex], decoded);
        try {
            decoded.salt = this.base64decode(parts[saltIndex]);
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Could not decode salt", (Throwable)e);
        }
        try {
            decoded.hash = this.base64decode(parts[hashIndex]);
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Could not decode hash", (Throwable)e);
        }
        return decoded;
    }

    private void parseOptions(String options, DecodedHash decoded) {
        String[] opts = this.split(options, ',', 3);
        if (opts.length != 3) {
            throw new Jargon2BackendException("Wrong number of hashing options");
        }
        String memoryCostOption = opts[0];
        if (!memoryCostOption.startsWith("m=") || memoryCostOption.length() < 3) {
            throw new Jargon2BackendException("Wrong memory cost option");
        }
        try {
            decoded.memoryCost = Integer.parseInt(memoryCostOption.substring(2));
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Memory cost option is invalid");
        }
        String timeCostOption = opts[1];
        if (!timeCostOption.startsWith("t=") || timeCostOption.length() < 3) {
            throw new Jargon2BackendException("Wrong time cost option");
        }
        try {
            decoded.timeCost = Integer.parseInt(timeCostOption.substring(2));
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Time cost option is invalid");
        }
        String parallelismOption = opts[2];
        if (!parallelismOption.startsWith("p=") || parallelismOption.length() < 3) {
            throw new Jargon2BackendException("Wrong parallelism option");
        }
        try {
            decoded.parallelism = Integer.parseInt(parallelismOption.substring(2));
        }
        catch (Exception e) {
            throw new Jargon2BackendException("Parallelism option is invalid");
        }
    }

    private String encodeString(Jargon2.Type type, Jargon2.Version version, int timeCost, int memoryCost, int lanes, byte[] salt, byte[] hash) {
        StringBuilder sb = new StringBuilder();
        sb.append('$').append(type.getValue());
        if (version.getValue() > Jargon2.Version.V10.getValue()) {
            sb.append('$').append("v=").append(version.getValue());
        }
        sb.append('$').append("m=").append(memoryCost).append(",t=").append(timeCost).append(",p=").append(lanes);
        sb.append('$').append(this.base64encode(salt));
        sb.append('$').append(this.base64encode(hash));
        return sb.toString();
    }

    private DisposableMemory createMemory(int length) {
        return new DisposableMemory(length);
    }

    private DisposableMemory copyToMemory(byte[] arr) {
        if (arr == null) {
            return null;
        }
        DisposableMemory m = new DisposableMemory(arr.length);
        m.write(0L, arr, 0, arr.length);
        return m;
    }

    private int convertVersion(Jargon2.Version version) {
        if (Jargon2.Version.V13.equals((Object)version)) {
            return 19;
        }
        if (Jargon2.Version.V10.equals((Object)version)) {
            return 16;
        }
        throw new Jargon2BackendException("Null or unsupported version detected: " + version);
    }

    private Jargon2.Version convertVersion(String version) {
        try {
            int v = Integer.parseInt(version);
            if (Jargon2.Version.V13.getValue() == v) {
                return Jargon2.Version.V13;
            }
            if (Jargon2.Version.V10.getValue() == v) {
                return Jargon2.Version.V10;
            }
            throw new Jargon2BackendException("Invalid version number. Check encoded hash.");
        }
        catch (NumberFormatException e) {
            throw new Jargon2BackendException("Non-numeric version. Check encoded hash.");
        }
    }

    private int convertType(Jargon2.Type type) {
        if (Jargon2.Type.ARGON2d.equals((Object)type)) {
            return 0;
        }
        if (Jargon2.Type.ARGON2i.equals((Object)type)) {
            return 1;
        }
        if (Jargon2.Type.ARGON2id.equals((Object)type)) {
            return 2;
        }
        throw new Jargon2BackendException("Null or unsupported type detected: " + type);
    }

    private Jargon2.Type convertType(String type) {
        if (Jargon2.Type.ARGON2d.getValue().equals(type)) {
            return Jargon2.Type.ARGON2d;
        }
        if (Jargon2.Type.ARGON2i.getValue().equals(type)) {
            return Jargon2.Type.ARGON2i;
        }
        if (Jargon2.Type.ARGON2id.getValue().equals(type)) {
            return Jargon2.Type.ARGON2id;
        }
        throw new Jargon2BackendException("Type did not decode properly. Check encoded hash.");
    }

    String[] split(String str, char delimiter, int maxTokens) {
        String[] tokens = new String[maxTokens];
        int from = 0;
        int i = 0;
        int len = str.length();
        while (from < len - 1 && i <= tokens.length - 1) {
            int delimIndex = str.indexOf(delimiter, from);
            if (delimIndex == -1) {
                if (from >= len) break;
                tokens[i++] = str.substring(from, len);
                break;
            }
            if (delimIndex > from) {
                tokens[i++] = str.substring(from, delimIndex);
            }
            from = delimIndex + 1;
        }
        if (i < tokens.length) {
            tokens = Arrays.copyOf(tokens, i);
        }
        return tokens;
    }

    char[] base64encode(byte[] data) {
        int base64Length = data.length / 3 * 4;
        int mod3 = data.length % 3;
        if (mod3 != 0) {
            base64Length += mod3 + 1;
        }
        char[] base64 = new char[base64Length];
        int i = 0;
        int j = 0;
        while (i < data.length - 2) {
            base64[j++] = encodeMapping[data[i] >>> 2 & 0x3F];
            base64[j++] = encodeMapping[data[i] << 4 & 0x30 | data[++i] >>> 4 & 0xF];
            base64[j++] = encodeMapping[data[i] << 2 & 0x3C | data[++i] >>> 6 & 3];
            base64[j++] = encodeMapping[data[i++] & 0x3F];
        }
        if (i == data.length - 1) {
            base64[j++] = encodeMapping[data[i] >>> 2 & 0x3F];
            base64[j] = encodeMapping[data[i] << 4 & 0x30];
        } else if (i == data.length - 2) {
            base64[j++] = encodeMapping[data[i] >>> 2 & 0x3F];
            base64[j++] = encodeMapping[data[i] << 4 & 0x30 | data[++i] >>> 4 & 0xF];
            base64[j] = encodeMapping[data[i] << 2 & 0x3C];
        }
        return base64;
    }

    private static byte decodeMapping(char c) {
        byte decoded;
        if (c > '\u007f' || (decoded = decodeMapping[c]) == -1) {
            throw new Jargon2BackendException("Invalid character in base64 string");
        }
        return decoded;
    }

    byte[] base64decode(String encoded) {
        int i;
        int outputLength = encoded.length() / 4 * 3;
        int mod4 = encoded.length() % 4;
        if (mod4 != 0) {
            outputLength += mod4 - 1;
        }
        byte[] output = new byte[outputLength];
        char[] buf = new char[4];
        int j = 0;
        for (i = 0; i < encoded.length() - 3; i += 4) {
            encoded.getChars(i, i + 4, buf, 0);
            output[j++] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[0]) << 2 | NativeRiJargon2Backend.decodeMapping(buf[1]) >>> 4);
            output[j++] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[1]) << 4 | NativeRiJargon2Backend.decodeMapping(buf[2]) >>> 2);
            output[j++] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[2]) << 6 | NativeRiJargon2Backend.decodeMapping(buf[3]) & 0xFF);
        }
        if (i == encoded.length() - 2) {
            encoded.getChars(i, i + 2, buf, 0);
            output[j] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[0]) << 2 | NativeRiJargon2Backend.decodeMapping(buf[1]) >>> 4);
        } else if (i == encoded.length() - 3) {
            encoded.getChars(i, i + 3, buf, 0);
            output[j++] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[0]) << 2 | NativeRiJargon2Backend.decodeMapping(buf[1]) >>> 4);
            output[j] = (byte)(NativeRiJargon2Backend.decodeMapping(buf[1]) << 4 | NativeRiJargon2Backend.decodeMapping(buf[2]) >>> 2);
        } else if (i != encoded.length()) {
            throw new Jargon2BackendException("Wrong number of characters in base64 string");
        }
        return output;
    }

    static class DisposableMemory
    extends Memory {
        DisposableMemory(long size) {
            super(size);
        }

        public void dispose() {
            super.dispose();
        }
    }

    static class DecodedHash {
        Jargon2.Type type;
        Jargon2.Version version;
        int memoryCost;
        int timeCost;
        int parallelism;
        byte[] salt;
        byte[] hash;

        DecodedHash() {
        }
    }
}

