/*
 * Decompiled with CFR 0.152.
 */
package com.kosprov.jargon2.internal.discovery;

import com.kosprov.jargon2.internal.discovery.Jargon2BackendDiscoveryException;
import com.kosprov.jargon2.spi.Jargon2Backend;
import java.util.HashSet;
import java.util.ServiceLoader;

public enum Jargon2BackendDiscovery {
    INSTANCE;

    private static final String JARGON2_BACKEND_SYSTEM_PROP_NAME = "com.kosprov.jargon2.spi.backend";
    private volatile Jargon2Backend backend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jargon2Backend getJargon2Backend() {
        if (this.backend == null) {
            Jargon2BackendDiscovery jargon2BackendDiscovery = this;
            synchronized (jargon2BackendDiscovery) {
                if (this.backend == null) {
                    HashSet<Jargon2Backend> backendsFound = new HashSet<Jargon2Backend>();
                    String backendClassName = System.getProperty(JARGON2_BACKEND_SYSTEM_PROP_NAME);
                    if (backendClassName != null && !"".equals(backendClassName.trim())) {
                        try {
                            backendsFound.add((Jargon2Backend)Class.forName(backendClassName).newInstance());
                        }
                        catch (Exception e) {
                            throw new Jargon2BackendDiscoveryException("Could not create Jargon2Backend instance from class " + backendClassName, e);
                        }
                    }
                    ServiceLoader<Jargon2Backend> loader = ServiceLoader.load(Jargon2Backend.class);
                    for (Jargon2Backend loadedBackend : loader) {
                        backendsFound.add(loadedBackend);
                    }
                    if (backendsFound.size() == 1) {
                        this.backend = (Jargon2Backend)backendsFound.iterator().next();
                    } else {
                        if (backendsFound.size() > 1) {
                            StringBuilder sb = new StringBuilder();
                            sb.append('[');
                            for (Jargon2Backend b : backendsFound) {
                                sb.append(b.getClass().getName()).append(", ");
                            }
                            sb.setLength(sb.length() - 2);
                            sb.append(']');
                            throw new Jargon2BackendDiscoveryException("Found more than one Jargon2Backends: " + sb.toString());
                        }
                        throw new Jargon2BackendDiscoveryException("Could not find appropriate jargon2Backend. Use either a service provider or define its class with -Dcom.kosprov.jargon2.spi.backend");
                    }
                }
            }
        }
        return this.backend;
    }
}

