/*
 * Decompiled with CFR 0.152.
 */
package com.kosprov.jargon2.api;

import com.kosprov.jargon2.api.Jargon2Exception;
import com.kosprov.jargon2.internal.ByteArrayImpl;
import com.kosprov.jargon2.internal.HasherImpl;
import com.kosprov.jargon2.internal.Jargon2BackendAdapter;
import com.kosprov.jargon2.internal.VerifierImpl;
import com.kosprov.jargon2.internal.discovery.Jargon2BackendDiscovery;
import com.kosprov.jargon2.spi.Jargon2Backend;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Map;

public class Jargon2 {
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final int STREAM_BUFFER_SIZE = 64;
    public static final Normalization DEFAULT_NORMALIZED_FORM = Normalization.NFC;

    public static Hasher jargon2Hasher() {
        return new HasherImpl();
    }

    public static Verifier jargon2Verifier() {
        return new VerifierImpl();
    }

    public static LowLevelApi jargon2LowLevelApi() {
        return Jargon2.jargon2LowLevelApi(Jargon2BackendDiscovery.INSTANCE.getJargon2Backend());
    }

    public static LowLevelApi jargon2LowLevelApi(Jargon2Backend backend) {
        return new Jargon2BackendAdapter(backend);
    }

    public static LowLevelApi jargon2LowLevelApi(String backendClass) {
        try {
            return Jargon2.jargon2LowLevelApi(Class.forName(backendClass).asSubclass(Jargon2Backend.class));
        }
        catch (Exception e) {
            throw new Jargon2Exception("Could not create Jargon2Backend instance from class " + backendClass);
        }
    }

    public static LowLevelApi jargon2LowLevelApi(Class<? extends Jargon2Backend> backendClass) {
        try {
            return Jargon2.jargon2LowLevelApi(backendClass.newInstance());
        }
        catch (Exception e) {
            throw new Jargon2Exception("Could not create Jargon2Backend instance from class " + backendClass);
        }
    }

    public static CharSeqByteArray toByteArray(String value) {
        return new ByteArrayImpl.CharSeqByteArrayImpl(value, DEFAULT_ENCODING);
    }

    public static ClearableSourceCharSeqByteArray toByteArray(char[] value) {
        return new ByteArrayImpl.ClearableSourceCharSeqByteArrayImpl(value, DEFAULT_ENCODING);
    }

    public static ClearableSourceByteArray toByteArray(byte[] bytes) {
        return new ByteArrayImpl.ClearableSourceByteArrayImpl(bytes);
    }

    public static ByteArray toByteArray(InputStream is) {
        return new ByteArrayImpl(is, 64);
    }

    public static ByteArray toByteArray(InputStream is, int bufferSize) {
        return new ByteArrayImpl(is, bufferSize);
    }

    public static CharSeqByteArray toByteArray(Reader reader) {
        return new ByteArrayImpl.CharSeqByteArrayImpl(reader, 64, DEFAULT_ENCODING);
    }

    public static CharSeqByteArray toByteArray(Reader reader, int bufferSize) {
        return new ByteArrayImpl.CharSeqByteArrayImpl(reader, bufferSize, DEFAULT_ENCODING);
    }

    public static interface RawVerifier
    extends Verifier {
        @Override
        public RawVerifier backend(Jargon2Backend var1);

        @Override
        public RawVerifier backend(String var1);

        @Override
        public RawVerifier backend(Class<? extends Jargon2Backend> var1);

        @Override
        public RawVerifier options(Map<String, Object> var1);

        @Override
        public RawVerifier type(Type var1);

        @Override
        public RawVerifier version(Version var1);

        @Override
        public RawVerifier timeCost(int var1);

        @Override
        public RawVerifier memoryCost(int var1);

        @Override
        public RawVerifier parallelism(int var1);

        @Override
        public RawVerifier parallelism(int var1, int var2);

        @Override
        public RawVerifier threads(int var1);

        @Override
        public RawVerifier salt(byte[] var1);

        @Override
        public RawVerifier salt(ByteArray var1);

        @Override
        public RawVerifier password(byte[] var1);

        @Override
        public RawVerifier password(ByteArray var1);

        @Override
        public RawVerifier secret(byte[] var1);

        @Override
        public RawVerifier secret(ByteArray var1);

        @Override
        public RawVerifier ad(byte[] var1);

        @Override
        public RawVerifier ad(ByteArray var1);

        @Override
        public EncodedVerifier hash(String var1);

        @Override
        public RawVerifier hash(byte[] var1);

        public boolean verifyRaw();
    }

    public static interface EncodedVerifier
    extends Verifier {
        @Override
        public EncodedVerifier backend(Jargon2Backend var1);

        @Override
        public EncodedVerifier backend(String var1);

        @Override
        public EncodedVerifier backend(Class<? extends Jargon2Backend> var1);

        @Override
        public EncodedVerifier options(Map<String, Object> var1);

        @Override
        public EncodedVerifier type(Type var1);

        @Override
        public EncodedVerifier version(Version var1);

        @Override
        public EncodedVerifier timeCost(int var1);

        @Override
        public EncodedVerifier memoryCost(int var1);

        @Override
        public EncodedVerifier parallelism(int var1);

        @Override
        public EncodedVerifier parallelism(int var1, int var2);

        @Override
        public EncodedVerifier threads(int var1);

        @Override
        public EncodedVerifier salt(byte[] var1);

        @Override
        public EncodedVerifier salt(ByteArray var1);

        @Override
        public EncodedVerifier password(byte[] var1);

        @Override
        public EncodedVerifier password(ByteArray var1);

        @Override
        public EncodedVerifier secret(byte[] var1);

        @Override
        public EncodedVerifier secret(ByteArray var1);

        @Override
        public EncodedVerifier ad(byte[] var1);

        @Override
        public EncodedVerifier ad(ByteArray var1);

        @Override
        public EncodedVerifier hash(String var1);

        @Override
        public RawVerifier hash(byte[] var1);

        public boolean verifyEncoded();
    }

    public static interface Verifier {
        public Verifier backend(Jargon2Backend var1);

        public Verifier backend(String var1);

        public Verifier backend(Class<? extends Jargon2Backend> var1);

        public Verifier options(Map<String, Object> var1);

        public Verifier type(Type var1);

        public Verifier version(Version var1);

        public Verifier timeCost(int var1);

        public Verifier memoryCost(int var1);

        public Verifier parallelism(int var1);

        public Verifier parallelism(int var1, int var2);

        public Verifier threads(int var1);

        public Verifier salt(byte[] var1);

        public Verifier salt(ByteArray var1);

        public Verifier password(byte[] var1);

        public Verifier password(ByteArray var1);

        public Verifier secret(byte[] var1);

        public Verifier secret(ByteArray var1);

        public Verifier ad(byte[] var1);

        public Verifier ad(ByteArray var1);

        public EncodedVerifier hash(String var1);

        public RawVerifier hash(byte[] var1);
    }

    public static interface Hasher {
        public Hasher backend(Jargon2Backend var1);

        public Hasher backend(String var1);

        public Hasher backend(Class<? extends Jargon2Backend> var1);

        public Hasher options(Map<String, Object> var1);

        public Hasher type(Type var1);

        public Hasher version(Version var1);

        public Hasher timeCost(int var1);

        public Hasher memoryCost(int var1);

        public Hasher parallelism(int var1);

        public Hasher parallelism(int var1, int var2);

        public Hasher hashLength(int var1);

        public Hasher saltLength(int var1);

        public Hasher salt(byte[] var1);

        public Hasher salt(ByteArray var1);

        public Hasher saltGenerator(SaltGenerator var1);

        public Hasher saltGenerator(String var1);

        public Hasher saltGenerator(String var1, String var2);

        public Hasher saltGenerator(String var1, Provider var2);

        public Hasher password(byte[] var1);

        public Hasher password(ByteArray var1);

        public Hasher secret(byte[] var1);

        public Hasher secret(ByteArray var1);

        public Hasher ad(byte[] var1);

        public Hasher ad(ByteArray var1);

        public byte[] rawHash();

        public String encodedHash();

        public boolean propertiesMatch(String var1);
    }

    public static enum Normalization {
        NFD,
        NFC,
        NFKD,
        NFKC;

    }

    public static interface ClearableSourceCharSeqByteArray
    extends CharSeqByteArray,
    ClearableSource {
        @Override
        public ClearableSourceCharSeqByteArray finalizable();

        @Override
        public ClearableSourceCharSeqByteArray encoding(String var1);

        @Override
        public ClearableSourceCharSeqByteArray encoding(Charset var1);

        @Override
        public ClearableSourceCharSeqByteArray normalize();

        @Override
        public ClearableSourceCharSeqByteArray normalize(Normalization var1);

        @Override
        public ClearableSourceCharSeqByteArray clearSource();

        @Override
        public ClearableSourceCharSeqByteArray clearSource(boolean var1);
    }

    public static interface ClearableSourceByteArray
    extends ByteArray,
    ClearableSource {
        @Override
        public ClearableSourceByteArray finalizable();

        @Override
        public ClearableSourceByteArray clearSource();

        @Override
        public ClearableSourceByteArray clearSource(boolean var1);
    }

    static interface ClearableSource {
        public ClearableSource clearSource();

        public ClearableSource clearSource(boolean var1);
    }

    public static interface CharSeqByteArray
    extends ByteArray {
        @Override
        public CharSeqByteArray finalizable();

        public CharSeqByteArray encoding(String var1);

        public CharSeqByteArray encoding(Charset var1);

        public CharSeqByteArray normalize();

        public CharSeqByteArray normalize(Normalization var1);
    }

    public static interface ByteArray
    extends AutoCloseable {
        public byte[] getBytes();

        @Override
        public void close() throws Exception;

        public void clear();

        public ByteArray finalizable();
    }

    public static interface SaltGenerator {
        public void generate(byte[] var1);
    }

    public static interface LowLevelApi {
        public byte[] rawHash(Type var1, Version var2, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8);

        public byte[] rawHash(Type var1, Version var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, byte[] var9, byte[] var10, byte[] var11, Map<String, Object> var12);

        public String encodedHash(Type var1, Version var2, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8);

        public String encodedHash(Type var1, Version var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, byte[] var9, byte[] var10, byte[] var11, Map<String, Object> var12);

        public boolean verifyRaw(Type var1, Version var2, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8);

        public boolean verifyRaw(Type var1, Version var2, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10, byte[] var11, Map<String, Object> var12);

        public boolean verifyEncoded(String var1, byte[] var2);

        public boolean verifyEncoded(String var1, byte[] var2, byte[] var3, byte[] var4, Map<String, Object> var5);

        public boolean verifyEncoded(String var1, int var2, byte[] var3);

        public boolean verifyEncoded(String var1, int var2, byte[] var3, byte[] var4, byte[] var5, Map<String, Object> var6);
    }

    public static enum Version {
        V10(16),
        V13(19);

        private int value;

        private Version(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Type {
        ARGON2d,
        ARGON2i,
        ARGON2id;

        private String value = this.name().toLowerCase();
        private String valueCapitalized = Character.toUpperCase(this.value.charAt(0)) + this.value.substring(1);

        public String getValue() {
            return this.value;
        }

        public String getValueCapitalized() {
            return this.valueCapitalized;
        }
    }
}

