/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.gradle.plugin;

import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class AddCompileOnlyDependencyTask
extends DefaultTask {
    private Project project = this.getProject();

    public AddCompileOnlyDependencyTask() {
        this.project.getTasks().withType(JavaCompile.class).forEach(javaCompile -> javaCompile.dependsOn(new Object[]{this}));
        this.project.getTasks().withType(GroovyCompile.class).forEach(groovyCompile -> groovyCompile.dependsOn(new Object[]{this}));
        String groovyDependency = "org.codehaus.groovy:groovy-all" + ("3.0.17".isEmpty() ? "" : ":3.0.17");
        this.project.getDependencies().add("shadow", (Object)groovyDependency);
    }

    @TaskAction
    public void addDependency() {
        try {
            XmlParser parser = new XmlParser();
            File classpathFile = new File(".classpath");
            Node root = parser.parse(classpathFile);
            NodeList classpathEntries = (NodeList)root.get("classpathentry");
            classpathEntries.removeIf(o -> {
                Node node = (Node)o;
                Map attributes = node.attributes();
                Object fileKind = attributes.get("kind");
                return !fileKind.equals("lib");
            });
            classpathEntries.forEach(o -> {
                Node node = (Node)o;
                Map attributes = node.attributes();
                Object filePath = attributes.get("path");
                this.project.getDependencies().add("compileOnly", (Object)this.project.files(new Object[]{filePath}));
            });
        }
        catch (FileNotFoundException e) {
            System.out.println(".classpath Not Found. No dependency added!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

