/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.crypto.AESCipherCBCnoPad;
import com.itextpdf.kernel.crypto.AesDecryptor;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.IVGenerator;
import com.itextpdf.kernel.crypto.OutputStreamAesEncryption;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.crypto.securityhandler.StandardSecurityHandler;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfVersion;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardHandlerUsingAes256
extends StandardSecurityHandler {
    private static final int VALIDATION_SALT_OFFSET = 32;
    private static final int KEY_SALT_OFFSET = 40;
    private static final int SALT_LENGTH = 8;
    protected boolean encryptMetadata;
    private boolean isPdf2;

    public StandardHandlerUsingAes256(PdfDictionary encryptionDictionary, byte[] userPassword, byte[] ownerPassword, int permissions, boolean encryptMetadata, boolean embeddedFilesOnly, PdfVersion version) {
        this.isPdf2 = version != null && version.compareTo(PdfVersion.PDF_2_0) >= 0;
        this.initKeyAndFillDictionary(encryptionDictionary, userPassword, ownerPassword, permissions, encryptMetadata, embeddedFilesOnly);
    }

    public StandardHandlerUsingAes256(PdfDictionary encryptionDictionary, byte[] password) {
        this.initKeyAndReadDictionary(encryptionDictionary, password);
    }

    public boolean isEncryptMetadata() {
        return this.encryptMetadata;
    }

    @Override
    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
    }

    @Override
    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        return new OutputStreamAesEncryption(os, this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    public IDecryptor getDecryptor() {
        return new AesDecryptor(this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    public void setPermissions(int permissions, PdfDictionary encryptionDictionary) {
        super.setPermissions(permissions, encryptionDictionary);
        byte[] aes256Perms = this.getAes256Perms(permissions, this.isEncryptMetadata());
        encryptionDictionary.put(PdfName.Perms, new PdfLiteral(StreamUtil.createEscapedString((byte[])aes256Perms)));
    }

    void setAES256DicEntries(PdfDictionary encryptionDictionary, byte[] oeKey, byte[] ueKey, byte[] aes256Perms, boolean encryptMetadata, boolean embeddedFilesOnly) {
        int version = 5;
        int rAes256 = 5;
        int rAes256Pdf2 = 6;
        int revision = this.isPdf2 ? rAes256Pdf2 : rAes256;
        PdfName cryptoFilter = PdfName.AESV3;
        this.setEncryptionDictionaryEntries(encryptionDictionary, oeKey, ueKey, aes256Perms, encryptMetadata, embeddedFilesOnly, version, revision, cryptoFilter);
    }

    void setEncryptionDictionaryEntries(PdfDictionary encryptionDictionary, byte[] oeKey, byte[] ueKey, byte[] aes256Perms, boolean encryptMetadata, boolean embeddedFilesOnly, int version, int revision, PdfName cryptoFilter) {
        encryptionDictionary.put(PdfName.OE, new PdfLiteral(StreamUtil.createEscapedString((byte[])oeKey)));
        encryptionDictionary.put(PdfName.UE, new PdfLiteral(StreamUtil.createEscapedString((byte[])ueKey)));
        encryptionDictionary.put(PdfName.Perms, new PdfLiteral(StreamUtil.createEscapedString((byte[])aes256Perms)));
        encryptionDictionary.put(PdfName.R, new PdfNumber(revision));
        encryptionDictionary.put(PdfName.V, new PdfNumber(version));
        PdfDictionary stdcf = new PdfDictionary();
        stdcf.put(PdfName.Length, new PdfNumber(32));
        if (!encryptMetadata) {
            encryptionDictionary.put(PdfName.EncryptMetadata, PdfBoolean.FALSE);
        }
        if (embeddedFilesOnly) {
            stdcf.put(PdfName.AuthEvent, PdfName.EFOpen);
            encryptionDictionary.put(PdfName.EFF, PdfName.StdCF);
            encryptionDictionary.put(PdfName.StrF, PdfName.Identity);
            encryptionDictionary.put(PdfName.StmF, PdfName.Identity);
        } else {
            stdcf.put(PdfName.AuthEvent, PdfName.DocOpen);
            encryptionDictionary.put(PdfName.StrF, PdfName.StdCF);
            encryptionDictionary.put(PdfName.StmF, PdfName.StdCF);
        }
        stdcf.put(PdfName.CFM, cryptoFilter);
        PdfDictionary cf = new PdfDictionary();
        cf.put(PdfName.StdCF, stdcf);
        encryptionDictionary.put(PdfName.CF, cf);
    }

    boolean isPdf2(PdfDictionary encryptionDictionary) {
        return encryptionDictionary.getAsNumber(PdfName.R).getValue() == 6.0;
    }

    @Override
    protected void initMd5MessageDigest() {
    }

    private void initKeyAndFillDictionary(PdfDictionary encryptionDictionary, byte[] userPassword, byte[] ownerPassword, int permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        ownerPassword = this.generateOwnerPasswordIfNullOrEmpty(ownerPassword);
        permissions |= 0xFFFFE0C0;
        permissions &= 0xFFFFFFFC;
        try {
            if (userPassword == null) {
                userPassword = new byte[]{};
            } else if (userPassword.length > 127) {
                userPassword = Arrays.copyOf(userPassword, 127);
            }
            if (ownerPassword.length > 127) {
                ownerPassword = Arrays.copyOf(ownerPassword, 127);
            }
            byte[] userValAndKeySalt = IVGenerator.getIV(16);
            byte[] ownerValAndKeySalt = IVGenerator.getIV(16);
            this.nextObjectKey = IVGenerator.getIV(32);
            this.nextObjectKeySize = 32;
            byte[] hash = this.computeHash(userPassword, userValAndKeySalt, 0, 8);
            byte[] userKey = Arrays.copyOf(hash, 48);
            System.arraycopy(userValAndKeySalt, 0, userKey, 32, 16);
            hash = this.computeHash(userPassword, userValAndKeySalt, 8, 8);
            AESCipherCBCnoPad ac = new AESCipherCBCnoPad(true, hash);
            byte[] ueKey = ac.processBlock(this.nextObjectKey, 0, this.nextObjectKey.length);
            hash = this.computeHash(ownerPassword, ownerValAndKeySalt, 0, 8, userKey);
            byte[] ownerKey = Arrays.copyOf(hash, 48);
            System.arraycopy(ownerValAndKeySalt, 0, ownerKey, 32, 16);
            hash = this.computeHash(ownerPassword, ownerValAndKeySalt, 8, 8, userKey);
            ac = new AESCipherCBCnoPad(true, hash);
            byte[] oeKey = ac.processBlock(this.nextObjectKey, 0, this.nextObjectKey.length);
            byte[] aes256Perms = this.getAes256Perms(permissions, encryptMetadata);
            this.permissions = permissions;
            this.encryptMetadata = encryptMetadata;
            this.setStandardHandlerDicEntries(encryptionDictionary, userKey, ownerKey);
            this.setAES256DicEntries(encryptionDictionary, oeKey, ueKey, aes256Perms, encryptMetadata, embeddedFilesOnly);
        }
        catch (Exception ex) {
            throw new PdfException("PdfEncryption exception.", ex);
        }
    }

    private byte[] getAes256Perms(int permissions, boolean encryptMetadata) {
        byte[] permsp = IVGenerator.getIV(16);
        permsp[0] = (byte)permissions;
        permsp[1] = (byte)(permissions >> 8);
        permsp[2] = (byte)(permissions >> 16);
        permsp[3] = (byte)(permissions >> 24);
        permsp[4] = -1;
        permsp[5] = -1;
        permsp[6] = -1;
        permsp[7] = -1;
        permsp[8] = encryptMetadata ? 84 : 70;
        permsp[9] = 97;
        permsp[10] = 100;
        permsp[11] = 98;
        AESCipherCBCnoPad ac = new AESCipherCBCnoPad(true, this.nextObjectKey);
        byte[] aes256Perms = ac.processBlock(permsp, 0, permsp.length);
        return aes256Perms;
    }

    private void initKeyAndReadDictionary(PdfDictionary encryptionDictionary, byte[] password) {
        try {
            AESCipherCBCnoPad ac;
            if (password == null) {
                password = new byte[]{};
            } else if (password.length > 127) {
                password = Arrays.copyOf(password, 127);
            }
            this.isPdf2 = this.isPdf2(encryptionDictionary);
            byte[] oValue = this.truncateArray(this.getIsoBytes(encryptionDictionary.getAsString(PdfName.O)));
            byte[] uValue = this.truncateArray(this.getIsoBytes(encryptionDictionary.getAsString(PdfName.U)));
            byte[] oeValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.OE));
            byte[] ueValue = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.UE));
            byte[] perms = this.getIsoBytes(encryptionDictionary.getAsString(PdfName.Perms));
            PdfNumber pValue = (PdfNumber)encryptionDictionary.get(PdfName.P);
            this.permissions = pValue.intValue();
            byte[] hash = this.computeHash(password, oValue, 32, 8, uValue);
            this.usedOwnerPassword = StandardHandlerUsingAes256.equalsArray(hash, oValue, 32);
            if (this.usedOwnerPassword) {
                hash = this.computeHash(password, oValue, 40, 8, uValue);
                ac = new AESCipherCBCnoPad(false, hash);
                this.nextObjectKey = ac.processBlock(oeValue, 0, oeValue.length);
            } else {
                hash = this.computeHash(password, uValue, 32, 8);
                if (!StandardHandlerUsingAes256.equalsArray(hash, uValue, 32)) {
                    throw new BadPasswordException("Bad user password. Password is not provided or wrong password provided. Correct password should be passed to PdfReader constructor with properties. See ReaderProperties#setPassword() method.");
                }
                hash = this.computeHash(password, uValue, 40, 8);
                ac = new AESCipherCBCnoPad(false, hash);
                this.nextObjectKey = ac.processBlock(ueValue, 0, ueValue.length);
            }
            this.nextObjectKeySize = 32;
            ac = new AESCipherCBCnoPad(false, this.nextObjectKey);
            byte[] decPerms = ac.processBlock(perms, 0, perms.length);
            if (decPerms[9] != 97 || decPerms[10] != 100 || decPerms[11] != 98) {
                throw new BadPasswordException("Bad user password. Password is not provided or wrong password provided. Correct password should be passed to PdfReader constructor with properties. See ReaderProperties#setPassword() method.");
            }
            int permissionsDecoded = decPerms[0] & 0xFF | (decPerms[1] & 0xFF) << 8 | (decPerms[2] & 0xFF) << 16 | (decPerms[3] & 0xFF) << 24;
            boolean encryptMetadata = decPerms[8] == 84;
            Boolean encryptMetadataEntry = encryptionDictionary.getAsBool(PdfName.EncryptMetadata);
            if (permissionsDecoded != this.permissions || encryptMetadataEntry != null && encryptMetadata != encryptMetadataEntry) {
                Logger logger = LoggerFactory.getLogger(StandardHandlerUsingAes256.class);
                logger.error("Encryption dictionary entries P and EncryptMetadata have value that does not correspond to encrypted values in Perms key.");
            }
            this.permissions = permissionsDecoded;
            this.encryptMetadata = encryptMetadata;
        }
        catch (BadPasswordException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PdfException("PdfEncryption exception.", ex);
        }
    }

    private byte[] computeHash(byte[] password, byte[] salt, int saltOffset, int saltLen) throws NoSuchAlgorithmException {
        return this.computeHash(password, salt, saltOffset, saltLen, null);
    }

    private byte[] computeHash(byte[] password, byte[] salt, int saltOffset, int saltLen, byte[] userKey) throws NoSuchAlgorithmException {
        MessageDigest mdSha256 = MessageDigest.getInstance("SHA-256");
        mdSha256.update(password);
        mdSha256.update(salt, saltOffset, saltLen);
        if (userKey != null) {
            mdSha256.update(userKey);
        }
        byte[] k = mdSha256.digest();
        if (this.isPdf2) {
            byte[] e;
            int condVal;
            MessageDigest mdSha384 = MessageDigest.getInstance("SHA-384");
            MessageDigest mdSha512 = MessageDigest.getInstance("SHA-512");
            int userKeyLen = userKey != null ? userKey.length : 0;
            int passAndUserKeyLen = password.length + userKeyLen;
            int roundNum = 0;
            do {
                int k1RepLen = passAndUserKeyLen + k.length;
                byte[] k1 = new byte[k1RepLen * 64];
                System.arraycopy(password, 0, k1, 0, password.length);
                System.arraycopy(k, 0, k1, password.length, k.length);
                if (userKey != null) {
                    System.arraycopy(userKey, 0, k1, password.length + k.length, userKeyLen);
                }
                for (int i = 1; i < 64; ++i) {
                    System.arraycopy(k1, 0, k1, k1RepLen * i, k1RepLen);
                }
                AESCipherCBCnoPad cipher = new AESCipherCBCnoPad(true, Arrays.copyOf(k, 16), Arrays.copyOfRange(k, 16, 32));
                e = cipher.processBlock(k1, 0, k1.length);
                MessageDigest md = null;
                BigInteger i = new BigInteger(1, Arrays.copyOf(e, 16));
                int remainder = i.remainder(BigInteger.valueOf(3L)).intValue();
                switch (remainder) {
                    case 0: {
                        md = mdSha256;
                        break;
                    }
                    case 1: {
                        md = mdSha384;
                        break;
                    }
                    case 2: {
                        md = mdSha512;
                    }
                }
                assert (md != null);
                k = md.digest(e);
            } while (++roundNum <= 63 || (condVal = e[e.length - 1] & 0xFF) > roundNum - 32);
            k = k.length == 32 ? k : Arrays.copyOf(k, 32);
        }
        return k;
    }

    private byte[] truncateArray(byte[] array) {
        if (array.length == 48) {
            return array;
        }
        for (int i = 48; i < array.length; ++i) {
            if (array[i] == 0) continue;
            throw new PdfException("Password hash exceeds 48 bytes and extra bytes are not 0");
        }
        byte[] truncated = new byte[48];
        System.arraycopy(array, 0, truncated, 0, 48);
        return truncated;
    }
}

