/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.ContextualRule;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import java.util.List;

public abstract class ContextualTable<T extends ContextualRule> {
    protected OpenTypeFontTableReader openReader;
    protected int lookupFlag;

    protected ContextualTable(OpenTypeFontTableReader openReader, int lookupFlag) {
        this.openReader = openReader;
        this.lookupFlag = lookupFlag;
    }

    public T getMatchingContextRule(GlyphLine line) {
        if (line.getIdx() >= line.getEnd()) {
            return null;
        }
        Glyph g = line.get(line.getIdx());
        List<T> rules = this.getSetOfRulesForStartGlyph(g.getCode());
        for (ContextualRule rule : rules) {
            int lastGlyphIndex = this.checkIfContextMatch(line, rule);
            if (lastGlyphIndex == -1) continue;
            line.setStart(line.getIdx());
            line.setEnd(lastGlyphIndex + 1);
            return (T)rule;
        }
        return null;
    }

    protected abstract List<T> getSetOfRulesForStartGlyph(int var1);

    protected int checkIfContextMatch(GlyphLine line, T rule) {
        boolean isMatch;
        int j;
        OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
        gidx.setLine(line);
        gidx.setIdx(line.getIdx());
        for (j = 1; j < ((ContextualRule)rule).getContextLength(); ++j) {
            gidx.nextGlyph(this.openReader, this.lookupFlag);
            if (gidx.getGlyph() == null || !((ContextualRule)rule).isGlyphMatchesInput(gidx.getGlyph().getCode(), j)) break;
        }
        boolean bl = isMatch = j == ((ContextualRule)rule).getContextLength();
        if (isMatch) {
            return gidx.getIdx();
        }
        return -1;
    }
}

