/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.line.ext;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Path;
import com.himanshoe.charty.color.ChartyColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\f\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001a\u0010\r\u001a\u00020\u000e*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DEFAULT_FILL_ALPHA", "", "CONTROL_POINT_DIVISOR", "CONTROL_POINT_MULTIPLIER", "createAreaPath", "Landroidx/compose/ui/graphics/Path;", "pointPositions", "", "Landroidx/compose/ui/geometry/Offset;", "baselineY", "smoothCurve", "", "createLinePath", "drawSmoothCurve", "", "createAreaBrush", "Landroidx/compose/ui/graphics/Brush;", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "fillAlpha", "chartTop", "chartBottom", "createLineBrush", "charty_release"})
@SourceDebugExtension(value={"SMAP\nAreaChartExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaChartExtensions.kt\ncom/himanshoe/charty/line/ext/AreaChartExtensionsKt\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n65#2:114\n65#2:117\n69#2:120\n65#2:122\n69#2:125\n65#2:127\n65#2:130\n69#2:133\n65#2:135\n69#2:138\n65#2:140\n69#2:143\n65#2:146\n69#2:149\n65#2:152\n69#2:155\n60#3:115\n60#3:118\n70#3:121\n60#3:123\n70#3:126\n60#3:128\n60#3:131\n70#3:134\n60#3:136\n70#3:139\n60#3:141\n70#3:144\n60#3:147\n70#3:150\n60#3:153\n70#3:156\n22#4:116\n22#4:119\n22#4:124\n22#4:129\n22#4:132\n22#4:137\n22#4:142\n22#4:145\n22#4:148\n22#4:151\n22#4:154\n22#4:157\n1563#5:158\n1634#5,3:159\n*S KotlinDebug\n*F\n+ 1 AreaChartExtensions.kt\ncom/himanshoe/charty/line/ext/AreaChartExtensionsKt\n*L\n18#1:114\n19#1:117\n19#1:120\n25#1:122\n25#1:125\n29#1:127\n39#1:130\n39#1:133\n45#1:135\n45#1:138\n58#1:140\n59#1:143\n60#1:146\n61#1:149\n68#1:152\n69#1:155\n18#1:115\n19#1:118\n19#1:121\n25#1:123\n25#1:126\n29#1:128\n39#1:131\n39#1:134\n45#1:136\n45#1:139\n58#1:141\n59#1:144\n60#1:147\n61#1:150\n68#1:153\n69#1:156\n18#1:116\n19#1:119\n25#1:124\n29#1:129\n39#1:132\n45#1:137\n58#1:142\n59#1:145\n60#1:148\n61#1:151\n68#1:154\n69#1:157\n96#1:158\n96#1:159,3\n*E\n"})
public final class AreaChartExtensionsKt {
    private static final float DEFAULT_FILL_ALPHA = 0.3f;
    private static final float CONTROL_POINT_DIVISOR = 3.0f;
    private static final float CONTROL_POINT_MULTIPLIER = 2.0f;

    @NotNull
    public static final Path createAreaPath(@NotNull List<Offset> pointPositions, float baselineY, boolean smoothCurve) {
        Path path;
        Intrinsics.checkNotNullParameter(pointPositions, (String)"pointPositions");
        Path $this$createAreaPath_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        long arg0$iv = pointPositions.get(0).unbox-impl();
        boolean bl2 = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        $this$createAreaPath_u24lambda_u240.moveTo(Float.intBitsToFloat(bits$iv$iv$iv), baselineY);
        arg0$iv = pointPositions.get(0).unbox-impl();
        bl2 = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat1 = false;
        bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = pointPositions.get(0).unbox-impl();
        boolean bl3 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        $this$createAreaPath_u24lambda_u240.lineTo(f, Float.intBitsToFloat(bits$iv$iv$iv));
        if (smoothCurve) {
            AreaChartExtensionsKt.drawSmoothCurve($this$createAreaPath_u24lambda_u240, pointPositions);
        } else {
            int n = pointPositions.size();
            for (int i = 1; i < n; ++i) {
                long arg0$iv2 = pointPositions.get(i).unbox-impl();
                $i$f$getX-impl = false;
                long value$iv$iv2 = arg0$iv2;
                boolean $i$f$unpackFloat12 = false;
                int bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
                boolean $i$f$floatFromBits2 = false;
                float f2 = Float.intBitsToFloat(bits$iv$iv$iv2);
                arg0$iv2 = pointPositions.get(i).unbox-impl();
                $i$f$getY-impl = false;
                value$iv$iv2 = arg0$iv2;
                boolean $i$f$unpackFloat22 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                $i$f$floatFromBits2 = false;
                $this$createAreaPath_u24lambda_u240.lineTo(f2, Float.intBitsToFloat(bits$iv$iv$iv2));
            }
        }
        arg0$iv = ((Offset)CollectionsKt.last(pointPositions)).unbox-impl();
        bl2 = false;
        value$iv$iv = arg0$iv;
        $i$f$unpackFloat1 = false;
        bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        $i$f$floatFromBits = false;
        $this$createAreaPath_u24lambda_u240.lineTo(Float.intBitsToFloat(bits$iv$iv$iv), baselineY);
        $this$createAreaPath_u24lambda_u240.close();
        return path;
    }

    @NotNull
    public static final Path createLinePath(@NotNull List<Offset> pointPositions, boolean smoothCurve) {
        Path path;
        Intrinsics.checkNotNullParameter(pointPositions, (String)"pointPositions");
        Path $this$createLinePath_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        long arg0$iv = pointPositions.get(0).unbox-impl();
        boolean bl2 = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = pointPositions.get(0).unbox-impl();
        boolean bl3 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        $this$createLinePath_u24lambda_u240.moveTo(f, Float.intBitsToFloat(bits$iv$iv$iv));
        if (smoothCurve) {
            AreaChartExtensionsKt.drawSmoothCurve($this$createLinePath_u24lambda_u240, pointPositions);
        } else {
            int n = pointPositions.size();
            for (int i = 1; i < n; ++i) {
                long arg0$iv2 = pointPositions.get(i).unbox-impl();
                $i$f$getX-impl = false;
                long value$iv$iv2 = arg0$iv2;
                boolean $i$f$unpackFloat12 = false;
                int bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
                boolean $i$f$floatFromBits2 = false;
                float f2 = Float.intBitsToFloat(bits$iv$iv$iv2);
                arg0$iv2 = pointPositions.get(i).unbox-impl();
                $i$f$getY-impl = false;
                value$iv$iv2 = arg0$iv2;
                boolean $i$f$unpackFloat22 = false;
                bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                $i$f$floatFromBits2 = false;
                $this$createLinePath_u24lambda_u240.lineTo(f2, Float.intBitsToFloat(bits$iv$iv$iv2));
            }
        }
        return path;
    }

    private static final void drawSmoothCurve(Path $this$drawSmoothCurve, List<Offset> pointPositions) {
        int n = pointPositions.size() - 1;
        for (int i = 0; i < n; ++i) {
            long current = pointPositions.get(i).unbox-impl();
            long next = pointPositions.get(i + 1).unbox-impl();
            long arg0$iv = current;
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            float f = Float.intBitsToFloat(bits$iv$iv$iv);
            arg0$iv = next;
            bl = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            float f2 = Float.intBitsToFloat(bits$iv$iv$iv);
            arg0$iv = current;
            bl = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            float controlPoint1X = f + (f2 - Float.intBitsToFloat(bits$iv$iv$iv)) / 3.0f;
            long arg0$iv2 = current;
            boolean bl2 = false;
            long value$iv$iv2 = arg0$iv2;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits2 = false;
            float controlPoint1Y = Float.intBitsToFloat(bits$iv$iv$iv2);
            long arg0$iv3 = current;
            $i$f$getX-impl = false;
            long value$iv$iv3 = arg0$iv3;
            boolean $i$f$unpackFloat12 = false;
            int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            boolean $i$f$floatFromBits3 = false;
            float f3 = Float.intBitsToFloat(bits$iv$iv$iv3);
            arg0$iv3 = next;
            $i$f$getX-impl = false;
            value$iv$iv3 = arg0$iv3;
            $i$f$unpackFloat12 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            $i$f$floatFromBits3 = false;
            float f4 = Float.intBitsToFloat(bits$iv$iv$iv3);
            arg0$iv3 = current;
            $i$f$getX-impl = false;
            value$iv$iv3 = arg0$iv3;
            $i$f$unpackFloat12 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            $i$f$floatFromBits3 = false;
            float controlPoint2X = f3 + 2.0f * (f4 - Float.intBitsToFloat(bits$iv$iv$iv3)) / 3.0f;
            long arg0$iv4 = next;
            $i$f$getY-impl = false;
            long value$iv$iv4 = arg0$iv4;
            boolean $i$f$unpackFloat22 = false;
            int bits$iv$iv$iv4 = (int)(value$iv$iv4 & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits4 = false;
            float controlPoint2Y = Float.intBitsToFloat(bits$iv$iv$iv4);
            arg0$iv4 = next;
            $i$f$getX-impl = false;
            value$iv$iv4 = arg0$iv4;
            boolean $i$f$unpackFloat13 = false;
            bits$iv$iv$iv4 = (int)(value$iv$iv4 >> 32);
            $i$f$floatFromBits4 = false;
            float f5 = Float.intBitsToFloat(bits$iv$iv$iv4);
            arg0$iv4 = next;
            $i$f$getY-impl = false;
            value$iv$iv4 = arg0$iv4;
            $i$f$unpackFloat22 = false;
            bits$iv$iv$iv4 = (int)(value$iv$iv4 & 0xFFFFFFFFL);
            $i$f$floatFromBits4 = false;
            $this$drawSmoothCurve.cubicTo(controlPoint1X, controlPoint1Y, controlPoint2X, controlPoint2Y, f5, Float.intBitsToFloat(bits$iv$iv$iv4));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Brush createAreaBrush(@NotNull ChartyColor color, float fillAlpha, float chartTop, float chartBottom) {
        Brush brush;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ChartyColor chartyColor = color;
        if (chartyColor instanceof ChartyColor.Solid) {
            Object[] objectArray = new Color[]{Color.box-impl((long)Color.copy-wmQWz5c$default((long)((ChartyColor.Solid)color).getColor-0d7_KjU(), (float)fillAlpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null)), Color.box-impl((long)Color.copy-wmQWz5c$default((long)((ChartyColor.Solid)color).getColor-0d7_KjU(), (float)(fillAlpha * 0.3f), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null))};
            brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, (List)CollectionsKt.listOf((Object[])objectArray), (float)chartTop, (float)chartBottom, (int)0, (int)8, null);
        } else if (chartyColor instanceof ChartyColor.Gradient) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ChartyColor.Gradient)color).getColors();
            Brush.Companion companion = Brush.Companion;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Color)item$iv$iv).unbox-impl();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Color.box-impl((long)Color.copy-wmQWz5c$default((long)it, (float)(Color.getAlpha-impl((long)it) * fillAlpha), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null)));
            }
            brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)companion, (List)((List)destination$iv$iv), (float)chartTop, (float)chartBottom, (int)0, (int)8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return brush;
    }

    @NotNull
    public static final Brush createLineBrush(@NotNull ChartyColor color) {
        Brush brush;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ChartyColor chartyColor = color;
        if (chartyColor instanceof ChartyColor.Solid) {
            Object[] objectArray = new Color[]{Color.box-impl((long)((ChartyColor.Solid)color).getColor-0d7_KjU()), Color.box-impl((long)((ChartyColor.Solid)color).getColor-0d7_KjU())};
            brush = Brush.Companion.linearGradient-mHitzGk$default((Brush.Companion)Brush.Companion, (List)CollectionsKt.listOf((Object[])objectArray), (long)0L, (long)0L, (int)0, (int)14, null);
        } else if (chartyColor instanceof ChartyColor.Gradient) {
            brush = Brush.Companion.linearGradient-mHitzGk$default((Brush.Companion)Brush.Companion, ((ChartyColor.Gradient)color).getColors(), (long)0L, (long)0L, (int)0, (int)14, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return brush;
    }
}

