/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.common.draw;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.PathEffect;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurer;
import androidx.compose.ui.text.TextPainterKt;
import androidx.compose.ui.text.TextStyle;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.axis.AxisConfigKt;
import com.himanshoe.charty.common.config.ReferenceLineConfig;
import com.himanshoe.charty.common.config.ReferenceLineLabelPosition;
import com.himanshoe.charty.common.config.ReferenceLineStrokeStyle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a*\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a$\u0010\u0014\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a(\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a6\u0010\u001d\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a$\u0010 \u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"DEFAULT_DASH_INTERVAL", "", "DASH_PHASE_OFFSET", "CENTER_DIVISOR", "referenceValueWithinRange", "", "value", "minValue", "maxValue", "drawReferenceLine", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "orientation", "Lcom/himanshoe/charty/common/ChartOrientation;", "config", "Lcom/himanshoe/charty/common/config/ReferenceLineConfig;", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawHorizontalReferenceLine", "calculateVerticalLabelY", "labelPosition", "Lcom/himanshoe/charty/common/config/ReferenceLineLabelPosition;", "textHeight", "calculateVerticalLabelX", "x", "textWidth", "labelOffset", "drawVerticalLineWithLabel", "pathEffect", "Landroidx/compose/ui/graphics/PathEffect;", "drawVerticalReferenceLine", "charty_release"})
@SourceDebugExtension(value={"SMAP\nReferenceLineDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceLineDrawer.kt\ncom/himanshoe/charty/common/draw/ReferenceLineDrawerKt\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n*L\n1#1,200:1\n30#2:201\n30#2:205\n30#2:213\n30#2:217\n30#2:221\n30#2:229\n53#3,3:202\n53#3,3:206\n85#3:210\n90#3:212\n53#3,3:214\n53#3,3:218\n53#3,3:222\n85#3:226\n90#3:228\n53#3,3:230\n54#4:209\n59#4:211\n54#4:225\n59#4:227\n*S KotlinDebug\n*F\n+ 1 ReferenceLineDrawer.kt\ncom/himanshoe/charty/common/draw/ReferenceLineDrawerKt\n*L\n63#1:201\n64#1:205\n119#1:213\n157#1:217\n158#1:221\n176#1:229\n63#1:202,3\n64#1:206,3\n96#1:210\n97#1:212\n119#1:214,3\n157#1:218,3\n158#1:222,3\n170#1:226\n171#1:228\n176#1:230,3\n96#1:209\n97#1:211\n170#1:225\n171#1:227\n*E\n"})
public final class ReferenceLineDrawerKt {
    private static final float DEFAULT_DASH_INTERVAL = 10.0f;
    private static final float DASH_PHASE_OFFSET = 0.0f;
    private static final float CENTER_DIVISOR = 2.0f;

    private static final boolean referenceValueWithinRange(float value, float minValue, float maxValue) {
        if (minValue == maxValue) {
            return false;
        }
        return minValue <= value ? value <= maxValue : false;
    }

    public static final void drawReferenceLine(@NotNull DrawScope $this$drawReferenceLine, @NotNull ChartContext chartContext, @NotNull ChartOrientation orientation, @NotNull ReferenceLineConfig config, @NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)$this$drawReferenceLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        if (!config.isEnabled()) {
            return;
        }
        if (!ReferenceLineDrawerKt.referenceValueWithinRange(config.getValue(), chartContext.getMinValue(), chartContext.getMaxValue())) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                ReferenceLineDrawerKt.drawHorizontalReferenceLine($this$drawReferenceLine, chartContext, config, textMeasurer);
                break;
            }
            case 2: {
                ReferenceLineDrawerKt.drawVerticalReferenceLine($this$drawReferenceLine, chartContext, config, textMeasurer);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawHorizontalReferenceLine(DrawScope $this$drawHorizontalReferenceLine, ChartContext chartContext, ReferenceLineConfig config, TextMeasurer textMeasurer) {
        void x$iv;
        float f;
        float f2;
        PathEffect pathEffect;
        void x$iv2;
        void x$iv3;
        float y = chartContext.convertValueToYPosition(config.getValue());
        float f3 = chartContext.getLeft();
        float y$iv = y;
        boolean $i$f$Offset22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv3);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long start = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        float $i$f$Offset22 = chartContext.getRight();
        float y$iv2 = y;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv2);
        long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
        long end = Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
        switch (WhenMappings.$EnumSwitchMapping$1[config.getStrokeStyle().ordinal()]) {
            case 1: {
                pathEffect = null;
                break;
            }
            case 2: {
                float[] fArray = config.getDashIntervals();
                if (fArray == null) {
                    float[] fArray2 = new float[]{10.0f, 10.0f};
                    fArray = fArray2;
                }
                float[] intervals = fArray;
                pathEffect = PathEffect.Companion.dashPathEffect(intervals, 0.0f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PathEffect pathEffect2 = pathEffect;
        DrawScope.drawLine-NGM6Ib0$default((DrawScope)$this$drawHorizontalReferenceLine, (long)config.getColor-0d7_KjU(), (long)start, (long)end, (float)config.getStrokeWidth(), (int)0, (PathEffect)pathEffect2, (float)0.0f, null, (int)0, (int)464, null);
        String string2 = config.getLabel() != null ? config.getLabel() : (config.getShowValueInLabelWhenNoText() ? AxisConfigKt.formatAxisLabel(config.getValue()) : null);
        if (string2 == null) {
            return;
        }
        String labelText = string2;
        TextLayoutResult textLayoutResult = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)labelText, (TextStyle)config.getLabelTextStyle(), (int)0, (boolean)false, (int)0, (long)0L, null, null, null, (boolean)false, (int)1020, null);
        long arg0$iv = textLayoutResult.getSize-YbymL2g();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        float textWidth = (int)(value$iv$iv >> 32);
        long arg0$iv2 = textLayoutResult.getSize-YbymL2g();
        boolean $i$f$getHeight-impl22 = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackInt2 = false;
        float textHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        switch (WhenMappings.$EnumSwitchMapping$2[config.getLabelPosition().ordinal()]) {
            case 1: {
                f2 = chartContext.getLeft();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                f2 = chartContext.getLeft() + (chartContext.getWidth() - textWidth) / 2.0f;
                break;
            }
            case 5: {
                f2 = chartContext.getRight() - textWidth;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float x = f2;
        switch (WhenMappings.$EnumSwitchMapping$2[config.getLabelPosition().ordinal()]) {
            case 1: 
            case 3: 
            case 5: {
                f = y - config.getLabelOffset() - textHeight;
                break;
            }
            case 4: {
                f = y + config.getLabelOffset();
                break;
            }
            case 2: {
                f = y - textHeight / 2.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float yText = f;
        float $i$f$getHeight-impl22 = x;
        float y$iv3 = yText;
        boolean $i$f$Offset3 = false;
        boolean $i$f$packFloats3 = false;
        long v1$iv$iv3 = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv3 = Float.floatToRawIntBits(y$iv3);
        TextPainterKt.drawText-d8-rzKo$default((DrawScope)$this$drawHorizontalReferenceLine, (TextLayoutResult)textLayoutResult, (long)0L, (long)Offset.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv3 & 0xFFFFFFFFL)), (float)0.0f, null, null, null, (int)0, (int)250, null);
    }

    private static final float calculateVerticalLabelY(ReferenceLineLabelPosition labelPosition, ChartContext chartContext, float textHeight) {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$2[labelPosition.ordinal()]) {
            case 1: {
                f = chartContext.getBottom() - textHeight;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                f = chartContext.getTop() + (chartContext.getHeight() - textHeight) / 2.0f;
                break;
            }
            case 5: {
                f = chartContext.getTop();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private static final float calculateVerticalLabelX(ReferenceLineLabelPosition labelPosition, float x, float textWidth, float labelOffset) {
        float f;
        switch (WhenMappings.$EnumSwitchMapping$2[labelPosition.ordinal()]) {
            case 1: 
            case 3: 
            case 5: {
                f = x - textWidth - labelOffset;
                break;
            }
            case 4: {
                f = x + labelOffset;
                break;
            }
            case 2: {
                f = x - textWidth / 2.0f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawVerticalLineWithLabel(DrawScope $this$drawVerticalLineWithLabel, float x, ChartContext chartContext, ReferenceLineConfig config, TextMeasurer textMeasurer, PathEffect pathEffect) {
        void x$iv;
        float xText;
        float x$iv2;
        float f = x;
        float y$iv = chartContext.getTop();
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits(x$iv2);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long l = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        x$iv2 = x;
        y$iv = chartContext.getBottom();
        $i$f$Offset = false;
        $i$f$packFloats = false;
        v1$iv$iv = Float.floatToRawIntBits(x$iv2);
        v2$iv$iv = Float.floatToRawIntBits(y$iv);
        DrawScope.drawLine-NGM6Ib0$default((DrawScope)$this$drawVerticalLineWithLabel, (long)config.getColor-0d7_KjU(), (long)l, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (float)config.getStrokeWidth(), (int)0, (PathEffect)pathEffect, (float)0.0f, null, (int)0, (int)464, null);
        String string2 = config.getLabel() != null ? config.getLabel() : (config.getShowValueInLabelWhenNoText() ? AxisConfigKt.formatAxisLabel(config.getValue()) : null);
        if (string2 == null) {
            return;
        }
        String labelText = string2;
        TextLayoutResult textLayoutResult = TextMeasurer.measure-wNUYSr0$default((TextMeasurer)textMeasurer, (String)labelText, (TextStyle)config.getLabelTextStyle(), (int)0, (boolean)false, (int)0, (long)0L, null, null, null, (boolean)false, (int)1020, null);
        long arg0$iv = textLayoutResult.getSize-YbymL2g();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        float textWidth = (int)(value$iv$iv >> 32);
        long arg0$iv2 = textLayoutResult.getSize-YbymL2g();
        boolean $i$f$getHeight-impl22 = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackInt2 = false;
        float textHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        float y = ReferenceLineDrawerKt.calculateVerticalLabelY(config.getLabelPosition(), chartContext, textHeight);
        float $i$f$getHeight-impl22 = xText = ReferenceLineDrawerKt.calculateVerticalLabelX(config.getLabelPosition(), x, textWidth, config.getLabelOffset());
        float y$iv2 = y;
        boolean $i$f$Offset2 = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
        TextPainterKt.drawText-d8-rzKo$default((DrawScope)$this$drawVerticalLineWithLabel, (TextLayoutResult)textLayoutResult, (long)0L, (long)Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL)), (float)0.0f, null, null, null, (int)0, (int)250, null);
    }

    private static final void drawVerticalReferenceLine(DrawScope $this$drawVerticalReferenceLine, ChartContext chartContext, ReferenceLineConfig config, TextMeasurer textMeasurer) {
        PathEffect pathEffect;
        float range = chartContext.getMaxValue() - chartContext.getMinValue();
        if (range == 0.0f) {
            return;
        }
        float normalized = (config.getValue() - chartContext.getMinValue()) / range;
        float x = chartContext.getLeft() + normalized * chartContext.getWidth();
        switch (WhenMappings.$EnumSwitchMapping$1[config.getStrokeStyle().ordinal()]) {
            case 1: {
                pathEffect = null;
                break;
            }
            case 2: {
                float[] fArray = config.getDashIntervals();
                if (fArray == null) {
                    float[] fArray2 = new float[]{10.0f, 10.0f};
                    fArray = fArray2;
                }
                float[] intervals = fArray;
                pathEffect = PathEffect.Companion.dashPathEffect(intervals, 0.0f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PathEffect pathEffect2 = pathEffect;
        ReferenceLineDrawerKt.drawVerticalLineWithLabel($this$drawVerticalReferenceLine, x, chartContext, config, textMeasurer, pathEffect2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ChartOrientation.values().length];
            try {
                nArray[ChartOrientation.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChartOrientation.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReferenceLineStrokeStyle.values().length];
            try {
                nArray[ReferenceLineStrokeStyle.SOLID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceLineStrokeStyle.DASHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ReferenceLineLabelPosition.values().length];
            try {
                nArray[ReferenceLineLabelPosition.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceLineLabelPosition.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceLineLabelPosition.ABOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceLineLabelPosition.BELOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceLineLabelPosition.END.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

