/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.common;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Brush;
import com.himanshoe.charty.color.ChartyColor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J \u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u0003J\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u0003J\u0016\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aJ\n\u0010!\u001a\u00020\"*\u00020#J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003JY\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\u001aH\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u00063"}, d2={"Lcom/himanshoe/charty/common/ChartContext;", "", "left", "", "top", "right", "bottom", "width", "height", "minValue", "maxValue", "<init>", "(FFFFFFFF)V", "getLeft", "()F", "getTop", "getRight", "getBottom", "getWidth", "getHeight", "getMinValue", "getMaxValue", "convertValueToYPosition", "value", "calculateBarLeftPosition", "index", "", "totalBars", "barWidthFraction", "calculateBarWidth", "widthFraction", "calculateCenteredXPosition", "totalItems", "toVerticalGradientBrush", "Landroidx/compose/ui/graphics/Brush;", "Lcom/himanshoe/charty/color/ChartyColor;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "", "charty_release"})
@StabilityInferred(parameters=1)
public final class ChartContext {
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    private final float width;
    private final float height;
    private final float minValue;
    private final float maxValue;
    public static final int $stable;

    public ChartContext(float left, float top, float right, float bottom, float width, float height, float minValue, float maxValue) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = width;
        this.height = height;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getMinValue() {
        return this.minValue;
    }

    public final float getMaxValue() {
        return this.maxValue;
    }

    public final float convertValueToYPosition(float value) {
        float range = this.maxValue - this.minValue;
        if (range == 0.0f) {
            return this.bottom;
        }
        float normalized = (value - this.minValue) / range;
        return this.bottom - normalized * this.height;
    }

    public final float calculateBarLeftPosition(int index, int totalBars, float barWidthFraction) {
        float sectionWidth = this.width / (float)totalBars;
        float barWidth = sectionWidth * barWidthFraction;
        return this.left + sectionWidth * (float)index + (sectionWidth - barWidth) / 2.0f;
    }

    public static /* synthetic */ float calculateBarLeftPosition$default(ChartContext chartContext, int n, int n2, float f, int n3, Object object) {
        if ((n3 & 4) != 0) {
            f = 0.6f;
        }
        return chartContext.calculateBarLeftPosition(n, n2, f);
    }

    public final float calculateBarWidth(int totalBars, float widthFraction) {
        return this.width / (float)totalBars * widthFraction;
    }

    public static /* synthetic */ float calculateBarWidth$default(ChartContext chartContext, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.6f;
        }
        return chartContext.calculateBarWidth(n, f);
    }

    public final float calculateCenteredXPosition(int index, int totalItems) {
        return this.left + this.width * ((float)index + 0.5f) / (float)totalItems;
    }

    @NotNull
    public final Brush toVerticalGradientBrush(@NotNull ChartyColor $this$toVerticalGradientBrush) {
        Intrinsics.checkNotNullParameter((Object)$this$toVerticalGradientBrush, (String)"<this>");
        return Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, $this$toVerticalGradientBrush.getValue(), (float)this.top, (float)this.bottom, (int)0, (int)8, null);
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    public final float component5() {
        return this.width;
    }

    public final float component6() {
        return this.height;
    }

    public final float component7() {
        return this.minValue;
    }

    public final float component8() {
        return this.maxValue;
    }

    @NotNull
    public final ChartContext copy(float left, float top, float right, float bottom, float width, float height, float minValue, float maxValue) {
        return new ChartContext(left, top, right, bottom, width, height, minValue, maxValue);
    }

    public static /* synthetic */ ChartContext copy$default(ChartContext chartContext, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, Object object) {
        if ((n & 1) != 0) {
            f = chartContext.left;
        }
        if ((n & 2) != 0) {
            f2 = chartContext.top;
        }
        if ((n & 4) != 0) {
            f3 = chartContext.right;
        }
        if ((n & 8) != 0) {
            f4 = chartContext.bottom;
        }
        if ((n & 0x10) != 0) {
            f5 = chartContext.width;
        }
        if ((n & 0x20) != 0) {
            f6 = chartContext.height;
        }
        if ((n & 0x40) != 0) {
            f7 = chartContext.minValue;
        }
        if ((n & 0x80) != 0) {
            f8 = chartContext.maxValue;
        }
        return chartContext.copy(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @NotNull
    public String toString() {
        return "ChartContext(left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", width=" + this.width + ", height=" + this.height + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.left);
        result = result * 31 + Float.hashCode(this.top);
        result = result * 31 + Float.hashCode(this.right);
        result = result * 31 + Float.hashCode(this.bottom);
        result = result * 31 + Float.hashCode(this.width);
        result = result * 31 + Float.hashCode(this.height);
        result = result * 31 + Float.hashCode(this.minValue);
        result = result * 31 + Float.hashCode(this.maxValue);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChartContext)) {
            return false;
        }
        ChartContext chartContext = (ChartContext)other;
        if (Float.compare(this.left, chartContext.left) != 0) {
            return false;
        }
        if (Float.compare(this.top, chartContext.top) != 0) {
            return false;
        }
        if (Float.compare(this.right, chartContext.right) != 0) {
            return false;
        }
        if (Float.compare(this.bottom, chartContext.bottom) != 0) {
            return false;
        }
        if (Float.compare(this.width, chartContext.width) != 0) {
            return false;
        }
        if (Float.compare(this.height, chartContext.height) != 0) {
            return false;
        }
        if (Float.compare(this.minValue, chartContext.minValue) != 0) {
            return false;
        }
        return Float.compare(this.maxValue, chartContext.maxValue) == 0;
    }
}

