/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.candlestick.data;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010 \u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0005J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014JL\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020\u00172\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0015\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/himanshoe/charty/candlestick/data/CandleData;", "", "label", "", "open", "", "high", "low", "close", "volume", "<init>", "(Ljava/lang/String;FFFFLjava/lang/Float;)V", "getLabel", "()Ljava/lang/String;", "getOpen", "()F", "getHigh", "getLow", "getClose", "getVolume", "()Ljava/lang/Float;", "Ljava/lang/Float;", "isBullish", "", "()Z", "isBearish", "bodyHeight", "getBodyHeight", "upperWickLength", "getUpperWickLength", "lowerWickLength", "getLowerWickLength", "isDoji", "threshold", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;FFFFLjava/lang/Float;)Lcom/himanshoe/charty/candlestick/data/CandleData;", "equals", "other", "hashCode", "", "toString", "charty_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCandleData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandleData.kt\ncom/himanshoe/charty/candlestick/data/CandleData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class CandleData {
    @NotNull
    private final String label;
    private final float open;
    private final float high;
    private final float low;
    private final float close;
    @Nullable
    private final Float volume;
    public static final int $stable;

    public CandleData(@NotNull String label, float open, float high, float low, float close, @Nullable Float volume) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.label = label;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
        if (!(this.high >= this.low)) {
            boolean $i$a$-require-CandleData$52 = false;
            String $i$a$-require-CandleData$52 = "High value must be greater than or equal to low value";
            throw new IllegalArgumentException($i$a$-require-CandleData$52.toString());
        }
        if (!(this.open >= this.low && this.open <= this.high)) {
            boolean $i$a$-require-CandleData$62 = false;
            String $i$a$-require-CandleData$62 = "Open value must be between low and high";
            throw new IllegalArgumentException($i$a$-require-CandleData$62.toString());
        }
        if (!(this.close >= this.low && this.close <= this.high)) {
            boolean $i$a$-require-CandleData$72 = false;
            String $i$a$-require-CandleData$72 = "Close value must be between low and high";
            throw new IllegalArgumentException($i$a$-require-CandleData$72.toString());
        }
        if (this.volume != null && !(this.volume.floatValue() >= 0.0f)) {
            boolean bl = false;
            String string2 = "Volume must be non-negative";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ CandleData(String string2, float f, float f2, float f3, float f4, Float f5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            f5 = null;
        }
        this(string2, f, f2, f3, f4, f5);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final float getOpen() {
        return this.open;
    }

    public final float getHigh() {
        return this.high;
    }

    public final float getLow() {
        return this.low;
    }

    public final float getClose() {
        return this.close;
    }

    @Nullable
    public final Float getVolume() {
        return this.volume;
    }

    public final boolean isBullish() {
        return this.close >= this.open;
    }

    public final boolean isBearish() {
        return this.close < this.open;
    }

    public final float getBodyHeight() {
        return Math.abs(this.close - this.open);
    }

    public final float getUpperWickLength() {
        return this.high - Math.max(this.open, this.close);
    }

    public final float getLowerWickLength() {
        return Math.min(this.open, this.close) - this.low;
    }

    public final boolean isDoji(float threshold) {
        float range = this.high - this.low;
        return range == 0.0f ? true : this.getBodyHeight() / range < threshold;
    }

    public static /* synthetic */ boolean isDoji$default(CandleData candleData, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.01f;
        }
        return candleData.isDoji(f);
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    public final float component2() {
        return this.open;
    }

    public final float component3() {
        return this.high;
    }

    public final float component4() {
        return this.low;
    }

    public final float component5() {
        return this.close;
    }

    @Nullable
    public final Float component6() {
        return this.volume;
    }

    @NotNull
    public final CandleData copy(@NotNull String label, float open, float high, float low, float close, @Nullable Float volume) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return new CandleData(label, open, high, low, close, volume);
    }

    public static /* synthetic */ CandleData copy$default(CandleData candleData, String string2, float f, float f2, float f3, float f4, Float f5, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = candleData.label;
        }
        if ((n & 2) != 0) {
            f = candleData.open;
        }
        if ((n & 4) != 0) {
            f2 = candleData.high;
        }
        if ((n & 8) != 0) {
            f3 = candleData.low;
        }
        if ((n & 0x10) != 0) {
            f4 = candleData.close;
        }
        if ((n & 0x20) != 0) {
            f5 = candleData.volume;
        }
        return candleData.copy(string2, f, f2, f3, f4, f5);
    }

    @NotNull
    public String toString() {
        return "CandleData(label=" + this.label + ", open=" + this.open + ", high=" + this.high + ", low=" + this.low + ", close=" + this.close + ", volume=" + this.volume + ")";
    }

    public int hashCode() {
        int result = this.label.hashCode();
        result = result * 31 + Float.hashCode(this.open);
        result = result * 31 + Float.hashCode(this.high);
        result = result * 31 + Float.hashCode(this.low);
        result = result * 31 + Float.hashCode(this.close);
        result = result * 31 + (this.volume == null ? 0 : ((Object)this.volume).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CandleData)) {
            return false;
        }
        CandleData candleData = (CandleData)other;
        if (!Intrinsics.areEqual((Object)this.label, (Object)candleData.label)) {
            return false;
        }
        if (Float.compare(this.open, candleData.open) != 0) {
            return false;
        }
        if (Float.compare(this.high, candleData.high) != 0) {
            return false;
        }
        if (Float.compare(this.low, candleData.low) != 0) {
            return false;
        }
        if (Float.compare(this.close, candleData.close) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.volume, (Object)candleData.volume);
    }
}

