/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.candlestick.config;

import androidx.compose.runtime.internal.StabilityInferred;
import com.himanshoe.charty.common.config.Animation;
import com.himanshoe.charty.common.config.CornerRadius;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/himanshoe/charty/candlestick/config/CandlestickChartConfig;", "", "candleWidthFraction", "", "wickWidthFraction", "minCandleBodyHeight", "showWicks", "", "cornerRadius", "Lcom/himanshoe/charty/common/config/CornerRadius;", "animation", "Lcom/himanshoe/charty/common/config/Animation;", "<init>", "(FFFZLcom/himanshoe/charty/common/config/CornerRadius;Lcom/himanshoe/charty/common/config/Animation;)V", "getCandleWidthFraction", "()F", "getWickWidthFraction", "getMinCandleBodyHeight", "getShowWicks", "()Z", "getCornerRadius", "()Lcom/himanshoe/charty/common/config/CornerRadius;", "getAnimation", "()Lcom/himanshoe/charty/common/config/Animation;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "charty_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCandlestickChartConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandlestickChartConfig.kt\ncom/himanshoe/charty/candlestick/config/CandlestickChartConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class CandlestickChartConfig {
    private final float candleWidthFraction;
    private final float wickWidthFraction;
    private final float minCandleBodyHeight;
    private final boolean showWicks;
    @NotNull
    private final CornerRadius cornerRadius;
    @NotNull
    private final Animation animation;
    public static final int $stable = 8;

    public CandlestickChartConfig(float candleWidthFraction, float wickWidthFraction, float minCandleBodyHeight, boolean showWicks, @NotNull CornerRadius cornerRadius, @NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)cornerRadius, (String)"cornerRadius");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.candleWidthFraction = candleWidthFraction;
        this.wickWidthFraction = wickWidthFraction;
        this.minCandleBodyHeight = minCandleBodyHeight;
        this.showWicks = showWicks;
        this.cornerRadius = cornerRadius;
        this.animation = animation;
        float f = this.candleWidthFraction;
        if (!(0.0f <= f ? f <= 1.0f : false)) {
            boolean $i$a$-require-CandlestickChartConfig$42 = false;
            String $i$a$-require-CandlestickChartConfig$42 = "Candle width fraction must be between 0 and 1";
            throw new IllegalArgumentException($i$a$-require-CandlestickChartConfig$42.toString());
        }
        f = this.wickWidthFraction;
        if (!(0.0f <= f ? f <= 1.0f : false)) {
            boolean $i$a$-require-CandlestickChartConfig$52 = false;
            String $i$a$-require-CandlestickChartConfig$52 = "Wick width fraction must be between 0 and 1";
            throw new IllegalArgumentException($i$a$-require-CandlestickChartConfig$52.toString());
        }
        if (!(this.minCandleBodyHeight >= 0.0f)) {
            boolean bl = false;
            String string2 = "Minimum candle body height must be non-negative";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ CandlestickChartConfig(float f, float f2, float f3, boolean bl, CornerRadius cornerRadius, Animation animation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.7f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        if ((n & 4) != 0) {
            f3 = 2.0f;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            cornerRadius = CornerRadius.None.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            animation = Animation.Companion.getDefault();
        }
        this(f, f2, f3, bl, cornerRadius, animation);
    }

    public final float getCandleWidthFraction() {
        return this.candleWidthFraction;
    }

    public final float getWickWidthFraction() {
        return this.wickWidthFraction;
    }

    public final float getMinCandleBodyHeight() {
        return this.minCandleBodyHeight;
    }

    public final boolean getShowWicks() {
        return this.showWicks;
    }

    @NotNull
    public final CornerRadius getCornerRadius() {
        return this.cornerRadius;
    }

    @NotNull
    public final Animation getAnimation() {
        return this.animation;
    }

    public final float component1() {
        return this.candleWidthFraction;
    }

    public final float component2() {
        return this.wickWidthFraction;
    }

    public final float component3() {
        return this.minCandleBodyHeight;
    }

    public final boolean component4() {
        return this.showWicks;
    }

    @NotNull
    public final CornerRadius component5() {
        return this.cornerRadius;
    }

    @NotNull
    public final Animation component6() {
        return this.animation;
    }

    @NotNull
    public final CandlestickChartConfig copy(float candleWidthFraction, float wickWidthFraction, float minCandleBodyHeight, boolean showWicks, @NotNull CornerRadius cornerRadius, @NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)cornerRadius, (String)"cornerRadius");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        return new CandlestickChartConfig(candleWidthFraction, wickWidthFraction, minCandleBodyHeight, showWicks, cornerRadius, animation);
    }

    public static /* synthetic */ CandlestickChartConfig copy$default(CandlestickChartConfig candlestickChartConfig, float f, float f2, float f3, boolean bl, CornerRadius cornerRadius, Animation animation, int n, Object object) {
        if ((n & 1) != 0) {
            f = candlestickChartConfig.candleWidthFraction;
        }
        if ((n & 2) != 0) {
            f2 = candlestickChartConfig.wickWidthFraction;
        }
        if ((n & 4) != 0) {
            f3 = candlestickChartConfig.minCandleBodyHeight;
        }
        if ((n & 8) != 0) {
            bl = candlestickChartConfig.showWicks;
        }
        if ((n & 0x10) != 0) {
            cornerRadius = candlestickChartConfig.cornerRadius;
        }
        if ((n & 0x20) != 0) {
            animation = candlestickChartConfig.animation;
        }
        return candlestickChartConfig.copy(f, f2, f3, bl, cornerRadius, animation);
    }

    @NotNull
    public String toString() {
        return "CandlestickChartConfig(candleWidthFraction=" + this.candleWidthFraction + ", wickWidthFraction=" + this.wickWidthFraction + ", minCandleBodyHeight=" + this.minCandleBodyHeight + ", showWicks=" + this.showWicks + ", cornerRadius=" + this.cornerRadius + ", animation=" + this.animation + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.candleWidthFraction);
        result = result * 31 + Float.hashCode(this.wickWidthFraction);
        result = result * 31 + Float.hashCode(this.minCandleBodyHeight);
        result = result * 31 + Boolean.hashCode(this.showWicks);
        result = result * 31 + this.cornerRadius.hashCode();
        result = result * 31 + this.animation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CandlestickChartConfig)) {
            return false;
        }
        CandlestickChartConfig candlestickChartConfig = (CandlestickChartConfig)other;
        if (Float.compare(this.candleWidthFraction, candlestickChartConfig.candleWidthFraction) != 0) {
            return false;
        }
        if (Float.compare(this.wickWidthFraction, candlestickChartConfig.wickWidthFraction) != 0) {
            return false;
        }
        if (Float.compare(this.minCandleBodyHeight, candlestickChartConfig.minCandleBodyHeight) != 0) {
            return false;
        }
        if (this.showWicks != candlestickChartConfig.showWicks) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cornerRadius, (Object)candlestickChartConfig.cornerRadius)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.animation, (Object)candlestickChartConfig.animation);
    }

    public CandlestickChartConfig() {
        this(0.0f, 0.0f, 0.0f, false, null, null, 63, null);
    }
}

