/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.waterfall;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.bar.config.WaterfallChartConfig;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.bar.internal.bar.waterfall.WaterfallBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aL\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0000\u001a<\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0000\u00a8\u0006\u0019"}, d2={"calculateWaterfallBarParams", "Lcom/himanshoe/charty/bar/internal/bar/waterfall/WaterfallBarDrawParams;", "index", "", "bar", "Lcom/himanshoe/charty/bar/data/BarData;", "items", "", "cumulativeValues", "", "config", "Lcom/himanshoe/charty/bar/config/WaterfallChartConfig;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "animationProgress", "drawWaterfallBar", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "brush", "Landroidx/compose/ui/graphics/Brush;", "x", "y", "width", "height", "cornerRadius", "charty_release"})
@SourceDebugExtension(value={"SMAP\nWaterfallChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterfallChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/waterfall/WaterfallChartDrawerKt\n+ 2 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,89:1\n33#2:90\n33#2:94\n53#3,3:91\n53#3,3:95\n*S KotlinDebug\n*F\n+ 1 WaterfallChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/waterfall/WaterfallChartDrawerKt\n*L\n79#1:90\n80#1:94\n79#1:91,3\n80#1:95,3\n*E\n"})
public final class WaterfallChartDrawerKt {
    @NotNull
    public static final WaterfallBarDrawParams calculateWaterfallBarParams(int index, @NotNull BarData bar, @NotNull List<BarData> items, @NotNull List<Float> cumulativeValues, @NotNull WaterfallChartConfig config, @NotNull ChartContext chartContext, float animationProgress) {
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(cumulativeValues, (String)"cumulativeValues");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        float barX = chartContext.calculateBarLeftPosition(index, items.size(), config.getBarWidthFraction());
        float barWidth = chartContext.calculateBarWidth(items.size(), config.getBarWidthFraction());
        float prevTotal = index == 0 ? 0.0f : ((Number)cumulativeValues.get(index - 1)).floatValue();
        float currTotal = ((Number)cumulativeValues.get(index)).floatValue();
        float startY = chartContext.convertValueToYPosition(prevTotal);
        float endY = chartContext.convertValueToYPosition(currTotal);
        boolean isIncrease = bar.getValue() >= 0.0f;
        float fullHeight = Math.abs(endY - startY);
        float animatedHeight = fullHeight * animationProgress;
        float animatedTop = isIncrease ? startY - animatedHeight : startY;
        ChartyColor baseColor = isIncrease ? config.getPositiveColor() : config.getNegativeColor();
        ChartyColor chartyColor = bar.getColor();
        if (chartyColor == null) {
            chartyColor = baseColor;
        }
        ChartyColor chartyColor2 = chartyColor;
        Brush brush = Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, chartyColor2.getValue(), (float)0.0f, (float)0.0f, (int)0, (int)14, null);
        Rect bounds = new Rect(barX, animatedTop, barX + barWidth, animatedTop + animatedHeight);
        return new WaterfallBarDrawParams(barX, animatedTop, barWidth, animatedHeight, brush, bounds);
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawWaterfallBar(@NotNull DrawScope $this$drawWaterfallBar, @NotNull Brush brush, float x, float y, float width, float height, float cornerRadius) {
        void x$iv;
        void x$iv2;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$drawWaterfallBar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        Path $this$drawWaterfallBar_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        float f = x + width;
        float f2 = y + height;
        float f3 = cornerRadius;
        float y$iv = cornerRadius;
        boolean $i$f$CornerRadius22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        float $i$f$CornerRadius22 = cornerRadius;
        float y$iv2 = cornerRadius;
        boolean $i$f$CornerRadius = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
        long l2 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
        long l3 = CornerRadius.Companion.getZero-kKHJgLs();
        long l4 = CornerRadius.Companion.getZero-kKHJgLs();
        Path.addRoundRect$default((Path)$this$drawWaterfallBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawWaterfallBar, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }
}

