/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.horizontal;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextMeasurer;
import com.himanshoe.charty.bar.config.BarChartConfig;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarChartHelpersKt;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.config.ReferenceLineConfig;
import com.himanshoe.charty.common.draw.ReferenceLineDrawerKt;
import com.himanshoe.charty.common.tooltip.TooltipDrawerKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a.\u0010\f\u001a\u00020\u0001*\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0000\u001aL\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u00a8\u0006\u001b"}, d2={"drawHorizontalBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "params", "Lcom/himanshoe/charty/bar/internal/bar/horizontal/HorizontalBarDrawParams;", "drawHorizontalReferenceLineIfNeeded", "barConfig", "Lcom/himanshoe/charty/bar/config/BarChartConfig;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "drawHorizontalTooltipIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "drawRoundedHorizontalBar", "brush", "Landroidx/compose/ui/graphics/Brush;", "x", "", "y", "width", "height", "isNegative", "", "isBelowAxisMode", "cornerRadius", "charty_release"})
@SourceDebugExtension(value={"SMAP\nHorizontalBarChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/horizontal/HorizontalBarChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,154:1\n71#2,5:155\n33#3:160\n33#3:164\n33#3:168\n33#3:172\n53#4,3:161\n53#4,3:165\n53#4,3:169\n53#4,3:173\n*S KotlinDebug\n*F\n+ 1 HorizontalBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/horizontal/HorizontalBarChartDrawerKt\n*L\n22#1:155,5\n129#1:160\n131#1:164\n143#1:168\n145#1:172\n129#1:161,3\n131#1:165,3\n143#1:169,3\n145#1:173,3\n*E\n"})
public final class HorizontalBarChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawHorizontalBars(@NotNull DrawScope $this$drawHorizontalBars, @NotNull HorizontalBarDrawParams params) {
        Intrinsics.checkNotNullParameter((Object)$this$drawHorizontalBars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        float range = params.getMaxValue() - params.getMinValue();
        List<BarData> $this$fastForEachIndexed$iv = params.getDataList();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            ChartyColor chartyColor;
            void bar;
            BarData item$iv;
            BarData barData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            float barHeight = params.getChartContext().getHeight() / (float)params.getDataList().size();
            float barY = params.getChartContext().getTop() + barHeight * (float)index;
            float barThickness = barHeight * params.getBarConfig().getBarWidthFraction();
            float centeredBarY = barY + (barHeight - barThickness) / (float)2;
            float valueNormalized = (bar.getValue() - params.getMinValue()) / range;
            float barValueX = params.getChartContext().getLeft() + params.getAxisOffset() + valueNormalized * (params.getChartContext().getWidth() - params.getAxisOffset());
            boolean isNegative = bar.getValue() < 0.0f;
            Pair<Float, Float> pair = HorizontalBarChartHelpersKt.calculateHorizontalBarDimensions(isNegative, params.isBelowAxisMode(), params.getBaselineX(), barValueX, params.getAnimationProgress());
            float barLeft = ((Number)pair.component1()).floatValue();
            float barWidth = ((Number)pair.component2()).floatValue();
            if (params.getOnBarClick() != null) {
                params.getOnBarBoundCalculated().invoke((Object)TuplesKt.to((Object)new Rect(barLeft, centeredBarY, barLeft + barWidth, centeredBarY + barThickness), (Object)bar));
            }
            if ((chartyColor = bar.getColor()) == null) {
                chartyColor = params.getColor();
            }
            ChartyColor barColor = chartyColor;
            Brush brush = Brush.Companion.horizontalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, barColor.getValue(), (float)params.getChartContext().getLeft(), (float)params.getChartContext().getRight(), (int)0, (int)8, null);
            HorizontalBarChartDrawerKt.drawRoundedHorizontalBar($this$drawHorizontalBars, brush, barLeft, centeredBarY, barWidth, barThickness, isNegative, params.isBelowAxisMode(), params.getBarConfig().getCornerRadius().getValue());
        }
    }

    public static final void drawHorizontalReferenceLineIfNeeded(@NotNull DrawScope $this$drawHorizontalReferenceLineIfNeeded, @NotNull BarChartConfig barConfig, @NotNull ChartContext chartContext, @NotNull TextMeasurer textMeasurer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$drawHorizontalReferenceLineIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)barConfig, (String)"barConfig");
            Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
            Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
            ReferenceLineConfig referenceLineConfig = barConfig.getReferenceLine();
            if (referenceLineConfig == null) break block0;
            ReferenceLineConfig referenceLineConfig2 = referenceLineConfig;
            boolean bl = false;
            ReferenceLineDrawerKt.drawReferenceLine($this$drawHorizontalReferenceLineIfNeeded, chartContext, ChartOrientation.HORIZONTAL, referenceLineConfig2, textMeasurer);
        }
    }

    public static final void drawHorizontalTooltipIfNeeded(@NotNull DrawScope $this$drawHorizontalTooltipIfNeeded, @Nullable TooltipState tooltipState, @NotNull BarChartConfig barConfig, @NotNull TextMeasurer textMeasurer, @NotNull ChartContext chartContext) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$drawHorizontalTooltipIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)barConfig, (String)"barConfig");
            Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
            Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
            TooltipState tooltipState2 = tooltipState;
            if (tooltipState2 == null) break block0;
            TooltipState state = tooltipState2;
            boolean bl = false;
            TooltipDrawerKt.drawTooltip($this$drawHorizontalTooltipIfNeeded, state, barConfig.getTooltipConfig(), textMeasurer, chartContext.getRight(), chartContext.getTop(), chartContext.getBottom());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawRoundedHorizontalBar(DrawScope $this$drawRoundedHorizontalBar, Brush brush, float x, float y, float width, float height, boolean isNegative, boolean isBelowAxisMode, float cornerRadius) {
        Path path;
        Path $this$drawRoundedHorizontalBar_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        if (isNegative && isBelowAxisMode) {
            void x$iv;
            void x$iv2;
            float f = x + width;
            float f2 = y + height;
            float f3 = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            long l2 = CornerRadius.Companion.getZero-kKHJgLs();
            float f4 = cornerRadius;
            float y$iv2 = cornerRadius;
            boolean $i$f$CornerRadius2 = false;
            boolean $i$f$packFloats2 = false;
            long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
            long l3 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
            long l4 = CornerRadius.Companion.getZero-kKHJgLs();
            Path.addRoundRect$default((Path)$this$drawRoundedHorizontalBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        } else {
            void x$iv;
            void x$iv3;
            float f = x + width;
            float f5 = y + height;
            long l = CornerRadius.Companion.getZero-kKHJgLs();
            float $i$f$CornerRadius = cornerRadius;
            float y$iv = cornerRadius;
            boolean $i$f$CornerRadius3 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv3);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l5 = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            long l6 = CornerRadius.Companion.getZero-kKHJgLs();
            float $i$f$CornerRadius2 = cornerRadius;
            float y$iv3 = cornerRadius;
            boolean $i$f$CornerRadius4 = false;
            boolean $i$f$packFloats3 = false;
            long v1$iv$iv3 = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv3 = Float.floatToRawIntBits(y$iv3);
            long l7 = CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv3 & 0xFFFFFFFFL));
            Path.addRoundRect$default((Path)$this$drawRoundedHorizontalBar_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f5, l, l5, l7, l6, null), null, (int)2, null);
        }
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawRoundedHorizontalBar, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }
}

