/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.bubblebar;

import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.axis.AxisConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a \u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a4\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u00a8\u0006\u0010"}, d2={"createAxisConfig", "Lcom/himanshoe/charty/common/axis/AxisConfig;", "minValue", "", "maxValue", "isBelowAxisMode", "", "calculateBaselineY", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "calculateBubbleBarDimensions", "Lkotlin/Pair;", "barValue", "baselineY", "barValueY", "animationProgress", "charty_release"})
public final class BubbleBarChartHelpersKt {
    @NotNull
    public static final AxisConfig createAxisConfig(float minValue, float maxValue, boolean isBelowAxisMode) {
        return new AxisConfig(minValue, maxValue, 6, null, isBelowAxisMode, 8, null);
    }

    public static final float calculateBaselineY(float minValue, boolean isBelowAxisMode, @NotNull ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        return minValue < 0.0f && isBelowAxisMode ? chartContext.convertValueToYPosition(0.0f) : chartContext.getBottom();
    }

    @NotNull
    public static final Pair<Float, Float> calculateBubbleBarDimensions(float barValue, float baselineY, float barValueY, float animationProgress) {
        Pair pair;
        boolean isNegative;
        boolean bl = isNegative = barValue < 0.0f;
        if (isNegative) {
            float barTop = baselineY;
            float fullBarHeight = barValueY - baselineY;
            float barHeight = fullBarHeight * animationProgress;
            pair = TuplesKt.to((Object)Float.valueOf(barTop), (Object)Float.valueOf(barHeight));
        } else {
            float fullBarHeight = baselineY - barValueY;
            float animatedBarHeight = fullBarHeight * animationProgress;
            float barTop = baselineY - animatedBarHeight;
            pair = TuplesKt.to((Object)Float.valueOf(barTop), (Object)Float.valueOf(animatedBarHeight));
        }
        return pair;
    }
}

