/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.bubblebar;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.bar.internal.bar.bubblebar.BubbleBarChartHelpersKt;
import com.himanshoe.charty.bar.internal.bar.bubblebar.BubbleBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.config.ReferenceLineConfig;
import com.himanshoe.charty.common.draw.ReferenceLineDrawerKt;
import com.himanshoe.charty.common.tooltip.TooltipDrawerKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001aD\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"drawBubbleBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "params", "Lcom/himanshoe/charty/bar/internal/bar/bubblebar/BubbleBarDrawParams;", "drawReferenceLineIfNeeded", "drawTooltipIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "drawBubbleBar", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "x", "", "y", "width", "height", "bubbleRadius", "bubbleSpacing", "charty_release"})
@SourceDebugExtension(value={"SMAP\nBubbleBarChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BubbleBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/bubblebar/BubbleBarChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,139:1\n71#2,5:140\n30#3:145\n53#4,3:146\n*S KotlinDebug\n*F\n+ 1 BubbleBarChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/bubblebar/BubbleBarChartDrawerKt\n*L\n23#1:140,5\n134#1:145\n134#1:146,3\n*E\n"})
public final class BubbleBarChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawBubbleBars(@NotNull DrawScope $this$drawBubbleBars, @NotNull BubbleBarDrawParams params) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBubbleBars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List<BarData> $this$fastForEachIndexed$iv = params.getDataList();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            ChartyColor chartyColor;
            void bar;
            BarData item$iv;
            BarData barData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            float barX = params.getChartContext().calculateBarLeftPosition(index, params.getDataList().size(), params.getBubbleConfig().getBarWidthFraction());
            float barWidth = params.getChartContext().calculateBarWidth(params.getDataList().size(), params.getBubbleConfig().getBarWidthFraction());
            float barValueY = params.getChartContext().convertValueToYPosition(bar.getValue());
            Pair<Float, Float> pair = BubbleBarChartHelpersKt.calculateBubbleBarDimensions(bar.getValue(), params.getBaselineY(), barValueY, params.getAnimationProgress());
            float barTop = ((Number)pair.component1()).floatValue();
            float barHeight = ((Number)pair.component2()).floatValue();
            if (params.getOnBarClick() != null) {
                params.getBarBounds().add((Pair<Rect, BarData>)TuplesKt.to((Object)new Rect(barX, barTop, barX + barWidth, barTop + barHeight), (Object)bar));
            }
            if ((chartyColor = bar.getColor()) == null) {
                chartyColor = params.getColor();
            }
            ChartyColor barColor = chartyColor;
            BubbleBarChartDrawerKt.drawBubbleBar($this$drawBubbleBars, barColor, barX, barTop, barWidth, barHeight, params.getBubbleConfig().getBubbleRadius(), params.getBubbleConfig().getBubbleSpacing());
        }
    }

    public static final void drawReferenceLineIfNeeded(@NotNull DrawScope $this$drawReferenceLineIfNeeded, @NotNull BubbleBarDrawParams params) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$drawReferenceLineIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            ReferenceLineConfig referenceLineConfig = params.getBubbleConfig().getReferenceLine();
            if (referenceLineConfig == null) break block0;
            ReferenceLineConfig referenceLineConfig2 = referenceLineConfig;
            boolean bl = false;
            ReferenceLineDrawerKt.drawReferenceLine($this$drawReferenceLineIfNeeded, params.getChartContext(), ChartOrientation.VERTICAL, referenceLineConfig2, params.getTextMeasurer());
        }
    }

    public static final void drawTooltipIfNeeded(@NotNull DrawScope $this$drawTooltipIfNeeded, @NotNull BubbleBarDrawParams params, @Nullable TooltipState tooltipState) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$drawTooltipIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            TooltipState tooltipState2 = tooltipState;
            if (tooltipState2 == null) break block0;
            TooltipState state = tooltipState2;
            boolean bl = false;
            TooltipDrawerKt.drawTooltip($this$drawTooltipIfNeeded, state, params.getBubbleConfig().getTooltipConfig(), params.getTextMeasurer(), params.getChartContext().getRight(), params.getChartContext().getTop(), params.getChartContext().getBottom());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawBubbleBar(DrawScope $this$drawBubbleBar, ChartyColor color, float x, float y, float width, float height, float bubbleRadius, float bubbleSpacing) {
        float bubbleY;
        if (height <= 0.0f) {
            return;
        }
        float centerX = x + width / 2.0f;
        float diameter = bubbleRadius * (float)2;
        float verticalStep = diameter + bubbleSpacing;
        int bubbleCount = Math.max(1, (int)Math.ceil(height / verticalStep));
        for (int i = 0; i < bubbleCount && !((bubbleY = y + height - (float)i * verticalStep - bubbleRadius) < y - bubbleRadius); ++i) {
            void x$iv;
            long l;
            ChartyColor chartyColor = color;
            if (chartyColor instanceof ChartyColor.Solid) {
                l = ((ChartyColor.Solid)color).getColor-0d7_KjU();
            } else if (chartyColor instanceof ChartyColor.Gradient) {
                List<Color> colors = ((ChartyColor.Gradient)color).getColors();
                float ratio = (float)i / (float)RangesKt.coerceAtLeast((int)bubbleCount, (int)1);
                float scaledRatio = ratio * (float)(colors.size() - 1);
                int index = RangesKt.coerceIn((int)((int)scaledRatio), (int)0, (int)(colors.size() - 2));
                float localRatio = scaledRatio - (float)index;
                l = ColorKt.lerp-jxsXWHM((long)colors.get(index).unbox-impl(), (long)colors.get(index + 1).unbox-impl(), (float)localRatio);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            long bubbleColor = l;
            float f = centerX;
            float y$iv = bubbleY;
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$drawBubbleBar, (long)bubbleColor, (float)bubbleRadius, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (float)0.0f, null, null, (int)0, (int)120, null);
        }
    }
}

