/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar;

import androidx.compose.animation.core.Animatable;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.text.TextMeasurer;
import androidx.compose.ui.text.TextMeasurerHelperKt;
import com.himanshoe.charty.bar.config.BarChartConfig;
import com.himanshoe.charty.bar.config.NegativeValuesDrawMode;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarChartDrawerKt;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarChartHelpersKt;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarChartRememberKt;
import com.himanshoe.charty.bar.internal.bar.horizontal.HorizontalBarDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.color.ChartyColors;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.ChartScaffoldKt;
import com.himanshoe.charty.common.axis.AxisConfig;
import com.himanshoe.charty.common.axis.LabelRotation;
import com.himanshoe.charty.common.config.ChartScaffoldConfig;
import com.himanshoe.charty.common.tooltip.TooltipManager;
import com.himanshoe.charty.common.tooltip.TooltipManagerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aa\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"HorizontalBarChart", "", "data", "Lkotlin/Function0;", "", "Lcom/himanshoe/charty/bar/data/BarData;", "modifier", "Landroidx/compose/ui/Modifier;", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "barConfig", "Lcom/himanshoe/charty/bar/config/BarChartConfig;", "scaffoldConfig", "Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;", "onBarClick", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Lcom/himanshoe/charty/color/ChartyColor;Lcom/himanshoe/charty/bar/config/BarChartConfig;Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;II)V", "charty_release"})
@SourceDebugExtension(value={"SMAP\nHorizontalBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalBarChart.kt\ncom/himanshoe/charty/bar/HorizontalBarChartKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1282#2,6:110\n1282#2,6:121\n1#3:116\n1563#4:117\n1634#4,3:118\n*S KotlinDebug\n*F\n+ 1 HorizontalBarChart.kt\ncom/himanshoe/charty/bar/HorizontalBarChartKt\n*L\n66#1:110,6\n83#1:121,6\n79#1:117\n79#1:118,3\n*E\n"})
public final class HorizontalBarChartKt {
    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void HorizontalBarChart(@NotNull Function0<? extends List<BarData>> data, @Nullable Modifier modifier, @Nullable ChartyColor color, @Nullable BarChartConfig barConfig, @Nullable ChartScaffoldConfig scaffoldConfig, @Nullable Function1<? super BarData, Unit> onBarClick, @Nullable Composer $composer, int $changed, int n) {
        block30: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            $composer = $composer.startRestartGroup(431407694);
            ComposerKt.sourceInformation((Composer)$composer, (String)"C(HorizontalBarChart)N(data,modifier,color,barConfig,scaffoldConfig,onBarClick)65@3293L25,68@3434L72,72@3707L48,73@3781L39,74@3844L22,82@4137L1074,76@3872L1339:HorizontalBarChart.kt#vfje09");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(data) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed((Object)modifier) ? 32 : 16;
            }
            if (($changed & 0x180) == 0) {
                $dirty |= (n & 4) == 0 && $composer.changed((Object)color) ? 256 : 128;
            }
            if (($changed & 0xC00) == 0) {
                $dirty |= (n & 8) == 0 && $composer.changedInstance((Object)barConfig) ? 2048 : 1024;
            }
            if (($changed & 0x6000) == 0) {
                $dirty |= (n & 0x10) == 0 && $composer.changed((Object)scaffoldConfig) ? 16384 : 8192;
            }
            if ((n & 0x20) != 0) {
                $dirty |= 0x30000;
            } else if (($changed & 0x30000) == 0) {
                $dirty |= $composer.changedInstance(onBarClick) ? 131072 : 65536;
            }
            if ($composer.shouldExecute(($dirty & 0x12493) != 74898, $dirty & 1)) {
                Object object;
                void $this$cache$iv;
                Collection collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object2;
                void $this$cache$iv2;
                $composer.startDefaults();
                if (($changed & 1) == 0 || $composer.getDefaultsInvalid()) {
                    if ((n & 2) != 0) {
                        modifier = (Modifier)Modifier.Companion;
                    }
                    if ((n & 4) != 0) {
                        color = new ChartyColor.Solid(ChartyColors.INSTANCE.getBlue-0d7_KjU(), null);
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        barConfig = new BarChartConfig(0.0f, 0.0f, null, null, null, null, null, null, null, 511, null);
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        scaffoldConfig = new ChartScaffoldConfig(false, false, false, 0L, null, 0L, 0.0f, 0.0f, null, 511, null);
                        $dirty &= 0xFFFF1FFF;
                    }
                    if ((n & 0x20) != 0) {
                        onBarClick = null;
                    }
                } else {
                    $composer.skipToGroupEnd();
                    if ((n & 4) != 0) {
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        $dirty &= 0xFFFF1FFF;
                    }
                }
                $composer.endDefaults();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)431407694, (int)$dirty, (int)-1, (String)"com.himanshoe.charty.bar.HorizontalBarChart (HorizontalBarChart.kt:64)");
                }
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-2029023001, (String)"CC(remember):HorizontalBarChart.kt#9igjgp");
                Composer composer = $composer;
                boolean invalid$iv = ($dirty & 0xE) == 4;
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv2.rememberedValue();
                boolean bl = false;
                if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                    boolean bl2 = false;
                    List value$iv = (List)data.invoke();
                    $this$cache$iv2.updateRememberedValue((Object)value$iv);
                    object2 = value$iv;
                } else {
                    object2 = it$iv;
                }
                Pair<Float, Float> pair = (Pair<Float, Float>)object2;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                Pair<Float, Float> dataList = pair;
                if (!(!((Collection)dataList).isEmpty())) {
                    boolean $i$a$-require-HorizontalBarChartKt$HorizontalBarChart$22 = false;
                    String $i$a$-require-HorizontalBarChartKt$HorizontalBarChart$22 = "Horizontal bar chart data cannot be empty";
                    throw new IllegalArgumentException($i$a$-require-HorizontalBarChartKt$HorizontalBarChart$22.toString());
                }
                pair = HorizontalBarChartRememberKt.rememberHorizontalValueRange((List<BarData>)dataList, barConfig.getNegativeValuesDrawMode(), $composer, 0);
                float minValue = ((Number)pair.component1()).floatValue();
                float maxValue = ((Number)pair.component2()).floatValue();
                boolean isBelowAxisMode = barConfig.getNegativeValuesDrawMode() == NegativeValuesDrawMode.BELOW_AXIS;
                boolean drawAxisAtZero = minValue < 0.0f && maxValue > 0.0f && isBelowAxisMode;
                Animatable<Float, ?> animationProgress = HorizontalBarChartRememberKt.rememberHorizontalAnimation(barConfig.getAnimation(), $composer, 0);
                TooltipManager tooltipManager = TooltipManagerKt.rememberTooltipManager($composer, 0);
                TextMeasurer textMeasurer = TextMeasurerHelperKt.rememberTextMeasurer((int)0, (Composer)$composer, (int)0, (int)1);
                Iterable iterable = (Iterable)dataList;
                Modifier modifier2 = modifier;
                boolean $i$f$map22 = false;
                void var21_30 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    BarData barData = (BarData)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getLabel());
                }
                Collection collection2 = (List)destination$iv$iv;
                Modifier modifier3 = modifier2;
                AxisConfig axisConfig = HorizontalBarChartHelpersKt.createHorizontalAxisConfig(minValue, maxValue, drawAxisAtZero);
                ChartScaffoldConfig chartScaffoldConfig = scaffoldConfig;
                ChartOrientation chartOrientation = ChartOrientation.HORIZONTAL;
                LabelRotation labelRotation = null;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-2028994944, (String)"CC(remember):HorizontalBarChart.kt#9igjgp");
                Composer $i$f$map22 = $composer;
                boolean invalid$iv2 = $composer.changedInstance(tooltipManager) | (($dirty & 0xE000 ^ 0x6000) > 16384 && $composer.changed((Object)scaffoldConfig) || ($dirty & 0x6000) == 16384) | $composer.changed(drawAxisAtZero) | $composer.changed(minValue) | $composer.changed(maxValue) | $composer.changedInstance(dataList) | $composer.changedInstance((Object)barConfig) | $composer.changedInstance(animationProgress) | (($dirty & 0x380 ^ 0x180) > 256 && $composer.changed((Object)color) || ($dirty & 0x180) == 256) | $composer.changed(isBelowAxisMode) | ($dirty & 0x70000) == 131072 | $composer.changed((Object)textMeasurer);
                boolean $i$f$cache2 = false;
                Object it$iv2 = $this$cache$iv.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv2 || it$iv2 == Composer.Companion.getEmpty()) {
                    LabelRotation labelRotation2 = labelRotation;
                    ChartOrientation chartOrientation2 = chartOrientation;
                    ChartScaffoldConfig chartScaffoldConfig2 = chartScaffoldConfig;
                    AxisConfig axisConfig2 = axisConfig;
                    collection = collection2;
                    modifier2 = modifier3;
                    boolean bl4 = false;
                    Function2 function2 = (arg_0, arg_1) -> HorizontalBarChartKt.HorizontalBarChart$lambda$3$0(tooltipManager, scaffoldConfig, drawAxisAtZero, minValue, maxValue, dataList, barConfig, animationProgress, color, isBelowAxisMode, onBarClick, textMeasurer, arg_0, arg_1);
                    modifier3 = modifier2;
                    collection2 = collection;
                    axisConfig = axisConfig2;
                    chartScaffoldConfig = chartScaffoldConfig2;
                    chartOrientation = chartOrientation2;
                    labelRotation = labelRotation2;
                    Function2 value$iv = function2;
                    $this$cache$iv.updateRememberedValue((Object)value$iv);
                    object = value$iv;
                } else {
                    object = it$iv2;
                }
                iterable = (Function2)object;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                ChartScaffoldKt.ChartScaffold(modifier3, collection2, axisConfig, chartScaffoldConfig, chartOrientation, labelRotation, (Function2<? super DrawScope, ? super ChartContext, Unit>)iterable, $composer, 0x6000 | 0xE & $dirty >> 3 | 0x1C00 & $dirty >> 3, 32);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block30;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> HorizontalBarChartKt.HorizontalBarChart$lambda$4(data, modifier, color, barConfig, scaffoldConfig, onBarClick, $changed, n, arg_0, arg_1));
        }
    }

    private static final Unit HorizontalBarChart$lambda$3$0(TooltipManager $tooltipManager, ChartScaffoldConfig $scaffoldConfig, boolean $drawAxisAtZero, float $minValue, float $maxValue, List $dataList, BarChartConfig $barConfig, Animatable $animationProgress, ChartyColor $color, boolean $isBelowAxisMode, Function1 $onBarClick, TextMeasurer $textMeasurer, DrawScope $this$ChartScaffold, ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$ChartScaffold, (String)"$this$ChartScaffold");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        $tooltipManager.clearBounds();
        float axisOffset = HorizontalBarChartHelpersKt.calculateHorizontalAxisOffset($scaffoldConfig);
        float baselineX = HorizontalBarChartHelpersKt.calculateHorizontalBaselineX($drawAxisAtZero, $minValue, $maxValue, chartContext, axisOffset);
        HorizontalBarChartDrawerKt.drawHorizontalBars($this$ChartScaffold, new HorizontalBarDrawParams($dataList, chartContext, $barConfig, baselineX, axisOffset, ((Number)$animationProgress.getValue()).floatValue(), $color, $isBelowAxisMode, $minValue, $maxValue, (Function1<? super BarData, Unit>)$onBarClick, (Function1<? super Pair<Rect, BarData>, Unit>)((Function1)arg_0 -> HorizontalBarChartKt.HorizontalBarChart$lambda$3$0$0($tooltipManager, arg_0))));
        HorizontalBarChartDrawerKt.drawHorizontalReferenceLineIfNeeded($this$ChartScaffold, $barConfig, chartContext, $textMeasurer);
        HorizontalBarChartDrawerKt.drawHorizontalTooltipIfNeeded($this$ChartScaffold, $tooltipManager.getTooltipState(), $barConfig, $textMeasurer, chartContext);
        return Unit.INSTANCE;
    }

    private static final Unit HorizontalBarChart$lambda$3$0$0(TooltipManager $tooltipManager, Pair bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        $tooltipManager.getBounds().add(bounds);
        return Unit.INSTANCE;
    }

    private static final Unit HorizontalBarChart$lambda$4(Function0 $data, Modifier $modifier, ChartyColor $color, BarChartConfig $barConfig, ChartScaffoldConfig $scaffoldConfig, Function1 $onBarClick, int $$changed, int $$default, Composer $composer, int $force) {
        HorizontalBarChartKt.HorizontalBarChart((Function0<? extends List<BarData>>)$data, $modifier, $color, $barConfig, $scaffoldConfig, (Function1<? super BarData, Unit>)$onBarClick, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }
}

