/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xservlet.servletstatus.EServletStatus;
import com.helger.xservlet.servletstatus.ServletStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletRegistration;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ServletStatusManager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStatusManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ServletStatus> m_aMap = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public ServletStatusManager() {
    }

    @Nonnull
    public static ServletStatusManager getInstance() {
        return (ServletStatusManager)ServletStatusManager.getGlobalSingleton(ServletStatusManager.class);
    }

    @Nullable
    public static ServletStatusManager getInstanceIfInstantiated() {
        return (ServletStatusManager)ServletStatusManager.getGlobalSingletonIfInstantiated(ServletStatusManager.class);
    }

    @Nonnull
    public EChange reset() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aMap.removeAll());
    }

    @Nonnull
    @Nonempty
    private static String _getKey(@Nonnull Class<? extends GenericServlet> clazz) {
        return clazz.getName();
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private ServletStatus _getOrCreateServletStatus(@Nonnull Class<? extends GenericServlet> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Servlet class");
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalStateException("Passed servlet class is abstract: " + String.valueOf(clazz));
        }
        String string2 = ServletStatusManager._getKey(clazz);
        return (ServletStatus)this.m_aMap.computeIfAbsent((Object)string2, string -> new ServletStatus(clazz.getName()));
    }

    private void _updateStatus(@Nonnull Class<? extends GenericServlet> clazz, @Nonnull EServletStatus eServletStatus) {
        ValueEnforcer.notNull((Object)((Object)eServletStatus), (String)"NewStatus");
        this.m_aRWLock.writeLocked(() -> this._getOrCreateServletStatus(clazz).internalSetCurrentStatus(eServletStatus));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Servlet status of " + String.valueOf(clazz) + " changed to " + String.valueOf((Object)eServletStatus));
        }
    }

    public void onServletCtor(@Nonnull Class<? extends GenericServlet> clazz) {
        this._updateStatus(clazz, EServletStatus.CONSTRUCTED);
    }

    public void onServletInit(@Nonnull Class<? extends GenericServlet> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onServletInit: " + String.valueOf(clazz));
        }
        this._updateStatus(clazz, EServletStatus.INITED);
    }

    public void onServletInitFailed(@Nonnull Exception exception, @Nonnull Class<? extends GenericServlet> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onServletInitFailed: " + String.valueOf(clazz), (Throwable)exception);
        }
        this._updateStatus(clazz, EServletStatus.CONSTRUCTED);
    }

    public void onServletInvocation(@Nonnull Class<? extends GenericServlet> clazz) {
        this.m_aRWLock.writeLocked(() -> this._getOrCreateServletStatus(clazz).internalIncrementInvocationCount());
    }

    public void onServletDestroy(@Nonnull Class<? extends GenericServlet> clazz) {
        this._updateStatus(clazz, EServletStatus.DESTROYED);
    }

    @Nullable
    public ServletStatus getStatus(@Nullable Class<? extends GenericServlet> clazz) {
        if (clazz == null) {
            return null;
        }
        String string = ServletStatusManager._getKey(clazz);
        return (ServletStatus)this.m_aRWLock.readLockedGet(() -> (ServletStatus)this.m_aMap.get((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, ServletStatus> getAllStatus() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aMap.getClone());
    }

    public static boolean isServletRegistered(@Nonnull Class<? extends GenericServlet> clazz) {
        String string = ((Class)ValueEnforcer.notNull(clazz, (String)"ServletClass")).getName();
        IGlobalWebScope iGlobalWebScope = WebScopeManager.getGlobalScopeOrNull();
        if (iGlobalWebScope != null) {
            try {
                for (ServletRegistration servletRegistration : iGlobalWebScope.getServletContext().getServletRegistrations().values()) {
                    if (!servletRegistration.getClassName().equals(string)) continue;
                    return true;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }
}

