/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import com.helger.xservlet.requesttrack.RequestTracker;
import jakarta.annotation.Nonnull;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XServletFilterTrackRequest
implements IXServletHighLevelFilter {
    public static final String REQUEST_ATTR_ID = "$ph-request.id";
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletFilterTrackRequest.class);
    private static final AtomicLong REQUEST_ID = new AtomicLong(0L);
    private boolean m_bTrackedRequest = false;

    private static boolean _trackBeforeHandleRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        String string = iRequestWebScope.attrs().getAsString((Object)REQUEST_ATTR_ID);
        if (string != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Request already contains an ID (" + string + ") - so this is a recursive request...");
            }
            return false;
        }
        string = Long.toString(REQUEST_ID.incrementAndGet());
        iRequestWebScope.attrs().putIn((Object)REQUEST_ATTR_ID, (Object)string);
        RequestTracker.addRequest(string, iRequestWebScope);
        return true;
    }

    private static void _trackAfterHandleRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        String string = iRequestWebScope.attrs().getAsString((Object)REQUEST_ATTR_ID);
        RequestTracker.removeRequest(string);
    }

    @Override
    public void beforeRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        this.m_bTrackedRequest = XServletFilterTrackRequest._trackBeforeHandleRequest(iRequestWebScope);
    }

    @Override
    public void afterRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        if (this.m_bTrackedRequest) {
            XServletFilterTrackRequest._trackAfterHandleRequest(iRequestWebScope);
        }
    }
}

