/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mgr;

import com.helger.web.scope.IWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EWebScope {
    GLOBAL,
    SESSION,
    REQUEST;


    @Nonnull
    public IWebScope getScope() {
        return this.getScope(true);
    }

    @Nullable
    public IWebScope getScope(boolean bl) {
        return EWebScope.getScope(this, bl);
    }

    @Nullable
    public static IWebScope getScope(@Nonnull EWebScope eWebScope, boolean bl) {
        switch (eWebScope.ordinal()) {
            case 0: {
                return bl ? WebScopeManager.getGlobalScope() : WebScopeManager.getGlobalScopeOrNull();
            }
            case 1: {
                return WebScopeManager.getSessionScope(bl);
            }
            case 2: {
                return bl ? WebScopeManager.getRequestScope() : WebScopeManager.getRequestScopeOrNull();
            }
        }
        throw new IllegalArgumentException("Unknown web scope: " + String.valueOf((Object)eWebScope));
    }
}

