/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.util;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.email.EmailAddressHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;

@ThreadSafe
public final class EmailAddressValidator {
    public static final boolean DEFAULT_PERFORM_MX_RECORD_CHECK = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAddressValidator.class);
    private static final AtomicBoolean PERFORM_MX_RECORD_CHECK = new AtomicBoolean(false);
    private static final EmailAddressValidator INSTANCE = new EmailAddressValidator();

    private EmailAddressValidator() {
    }

    public static void setPerformMXRecordCheck(boolean bl) {
        PERFORM_MX_RECORD_CHECK.set(bl);
        LOGGER.info("Email address record check is " + (bl ? "enabled" : "disabled"));
    }

    public static boolean isPerformMXRecordCheck() {
        return PERFORM_MX_RECORD_CHECK.get();
    }

    private static boolean _hasMXRecord(@Nonnull String string) {
        try {
            Record[] recordArray = new Lookup(string, 15).run();
            return recordArray != null && recordArray.length > 0;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to check for MX record on host '" + string + "': " + exception.getClass().getName() + " - " + exception.getMessage());
            return false;
        }
    }

    public static boolean isValid(@Nullable String string) {
        return PERFORM_MX_RECORD_CHECK.get() ? EmailAddressValidator.isValidWithMXCheck(string) : EmailAddressHelper.isValid((String)string);
    }

    public static boolean isValidWithMXCheck(@Nullable String string) {
        if (!EmailAddressHelper.isValid((String)string)) {
            return false;
        }
        String string2 = EmailAddressHelper.getUnifiedEmailAddress((String)string);
        int n = string2.indexOf(64);
        String string3 = string2.substring(n + 1);
        return EmailAddressValidator._hasMXRecord(string3);
    }
}

