/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ELockType;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.MustBeLocked;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.BasicThreadFactory;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.commons.vendor.VendorInfo;
import com.helger.datetime.helper.PDTFactory;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailQueuePerSMTP;
import com.helger.smtp.transport.MailSendException;
import com.helger.smtp.transport.MailTransportError;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.impl.StatisticsManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MailAPI {
    public static final String DEBUG_SUBJECT_PREFIX = "[DEBUG] ";
    public static final String DEFAULT_SUBJECT = "<no subject specified>";
    public static final boolean DEFAULT_STOP_IMMEDIATLY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAPI.class);
    private static final IMutableStatisticsHandlerCounter STATS_MAILS_QUEUED = StatisticsManager.getCounterHandler((String)(MailAPI.class.getName() + "$mails.queued"));
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<ISMTPSettings, MailQueuePerSMTP> QUEUE_CACHE = new CommonsHashMap();
    private static final ThreadFactory THREAD_FACTORY = BasicThreadFactory.builder().namingPattern("MailAPI-%d").daemon(true).priority(5).build();
    @GuardedBy(value="RW_LOCK")
    private static final ExecutorService SENDER_THREAD_POOL = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY);
    @GuardedBy(value="RW_LOCK")
    private static FailedMailQueue s_aFailedMailQueue = new FailedMailQueue();

    private MailAPI() {
    }

    @Nonnull
    public static FailedMailQueue getFailedMailQueue() {
        return (FailedMailQueue)RW_LOCK.readLockedGet(() -> s_aFailedMailQueue);
    }

    public static void setFailedMailQueue(@Nonnull FailedMailQueue failedMailQueue) {
        ValueEnforcer.notNull((Object)failedMailQueue, (String)"FailedMailQueue");
        RW_LOCK.writeLocked(() -> {
            s_aFailedMailQueue = failedMailQueue;
            for (MailQueuePerSMTP mailQueuePerSMTP : QUEUE_CACHE.values()) {
                mailQueuePerSMTP.setFailedMailQueue(failedMailQueue);
            }
        });
        LOGGER.info("Set FailedMailQueue to " + String.valueOf(failedMailQueue));
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private static MailQueuePerSMTP _getOrCreateMailQueuePerSMTP(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull((Object)iSMTPSettings, (String)"SmtpSettings");
        if (SENDER_THREAD_POOL.isShutdown()) {
            throw new IllegalStateException("Cannot submit to mailqueues that are already stopped!");
        }
        MailQueuePerSMTP mailQueuePerSMTP = (MailQueuePerSMTP)((Object)QUEUE_CACHE.get((Object)iSMTPSettings));
        if (mailQueuePerSMTP == null) {
            mailQueuePerSMTP = new MailQueuePerSMTP(EmailGlobalSettings.getMaxMailQueueLength(), EmailGlobalSettings.getMaxMailSendCount(), iSMTPSettings, MailAPI.getFailedMailQueue());
            QUEUE_CACHE.put((Object)iSMTPSettings, (Object)mailQueuePerSMTP);
            SENDER_THREAD_POOL.submit(() -> ((MailQueuePerSMTP)mailQueuePerSMTP).collect());
        }
        return mailQueuePerSMTP;
    }

    public static boolean hasNonVendorEmailAddress(@Nullable Iterable<? extends IEmailAddress> iterable) {
        if (iterable != null) {
            String string = VendorInfo.getVendorEmailSuffix();
            for (IEmailAddress iEmailAddress : iterable) {
                if (iEmailAddress.getAddress().endsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static ESuccess queueMail(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull IMutableEmailData iMutableEmailData) {
        int n = MailAPI.queueMails(iSMTPSettings, (Collection<? extends IMutableEmailData>)new CommonsArrayList((Object)iMutableEmailData));
        return ESuccess.valueOf((n == 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int queueMails(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull Collection<? extends IMutableEmailData> collection) {
        MailQueuePerSMTP mailQueuePerSMTP;
        ValueEnforcer.notNull((Object)iSMTPSettings, (String)"SmtpSettings");
        ValueEnforcer.notNull(collection, (String)"MailDataList");
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("At least one message has to be supplied!");
        }
        RW_LOCK.writeLock().lock();
        try {
            try {
                mailQueuePerSMTP = MailAPI._getOrCreateMailQueuePerSMTP(iSMTPSettings);
            }
            catch (IllegalStateException illegalStateException) {
                MailTransportError mailTransportError = new MailTransportError(illegalStateException);
                for (IMutableEmailData iMutableEmailData : collection) {
                    MailAPI.getFailedMailQueue().add(new FailedMailData(iSMTPSettings, iMutableEmailData, mailTransportError));
                }
                int n = 0;
                RW_LOCK.writeLock().unlock();
                return n;
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        int n = 0;
        boolean bl = GlobalDebug.isDebugMode();
        for (IMutableEmailData iMutableEmailData : collection) {
            if (iMutableEmailData == null) {
                LOGGER.error("Mail data is null! Ignoring this item completely.");
                continue;
            }
            STATS_MAILS_QUEUED.increment();
            boolean bl2 = true;
            if (iMutableEmailData.getFrom() == null) {
                LOGGER.error("Mail data has no sender address: " + String.valueOf(iMutableEmailData) + " - not queuing!");
                bl2 = false;
            }
            if (iMutableEmailData.to().isEmpty()) {
                LOGGER.error("Mail data has no receiver address: " + String.valueOf(iMutableEmailData) + " - not queuing!");
                bl2 = false;
            }
            if (bl && (MailAPI.hasNonVendorEmailAddress(iMutableEmailData.to()) || MailAPI.hasNonVendorEmailAddress(iMutableEmailData.cc()) || MailAPI.hasNonVendorEmailAddress(iMutableEmailData.bcc()))) {
                LOGGER.error("Debug mode: ignoring mail TO '" + String.valueOf(iMutableEmailData.to()) + "'" + (String)(iMutableEmailData.cc().isNotEmpty() ? " and CC '" + String.valueOf(iMutableEmailData.cc()) + "'" : "") + (String)(iMutableEmailData.bcc().isNotEmpty() ? " and BCC '" + String.valueOf(iMutableEmailData.bcc()) + "'" : "") + " because at least one address is not targeted to the vendor domain '" + VendorInfo.getVendorEmailSuffix() + "'");
                bl2 = false;
            }
            if (mailQueuePerSMTP.isStopped()) {
                LOGGER.error("Queue is already stopped - not queuing!");
                bl2 = false;
            }
            boolean bl3 = false;
            Exception exception = null;
            if (bl2) {
                if (StringHelper.isEmpty((String)iMutableEmailData.getSubject())) {
                    LOGGER.warn("Mail data has no subject: " + String.valueOf(iMutableEmailData) + " - defaulting to <no subject specified>");
                    iMutableEmailData.setSubject(DEFAULT_SUBJECT);
                }
                if (StringHelper.isEmpty((String)iMutableEmailData.getBody())) {
                    LOGGER.warn("Mail data has no body: " + String.valueOf(iMutableEmailData));
                }
                if (bl) {
                    if (!StringHelper.startsWith((String)iMutableEmailData.getSubject(), (String)DEBUG_SUBJECT_PREFIX)) {
                        iMutableEmailData.setSubject(DEBUG_SUBJECT_PREFIX + iMutableEmailData.getSubject());
                    }
                    LOGGER.info("Sending only-to-vendor mail in debug version:\n" + String.valueOf(iSMTPSettings) + "\n" + String.valueOf(iMutableEmailData));
                }
                iMutableEmailData.setSentDateTime(PDTFactory.getCurrentLocalDateTime());
                try {
                    if (mailQueuePerSMTP.queueObject(iMutableEmailData).isSuccess()) {
                        bl3 = true;
                        ++n;
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            } else {
                exception = new MailSendException("Email cannot be queued because internal constraints are not fulfilled!");
            }
            if (bl3) continue;
            mailQueuePerSMTP.getFailedMailQueue().add(new FailedMailData(iSMTPSettings, iMutableEmailData, new MailTransportError(exception)));
        }
        return n;
    }

    @Nonnegative
    @MustBeLocked(value=ELockType.READ)
    private static int _getTotalQueueLength() {
        int n = 0;
        for (MailQueuePerSMTP mailQueuePerSMTP : QUEUE_CACHE.values()) {
            n += mailQueuePerSMTP.getQueueLength();
        }
        return n;
    }

    @Nonnegative
    public static int getTotalQueueLength() {
        return RW_LOCK.readLockedInt(MailAPI::_getTotalQueueLength);
    }

    @Nonnull
    public static EChange stop() {
        return MailAPI.stop(false);
    }

    @Nonnull
    public static EChange stop(boolean bl) {
        RW_LOCK.writeLock().lock();
        try {
            if (SENDER_THREAD_POOL.isShutdown()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            SENDER_THREAD_POOL.shutdown();
            for (MailQueuePerSMTP mailQueuePerSMTP : QUEUE_CACHE.values()) {
                mailQueuePerSMTP.stopQueuingNewObjects(bl);
            }
            int n = QUEUE_CACHE.size();
            int n2 = MailAPI._getTotalQueueLength() - 1;
            if (n > 0 || n2 > 0) {
                LOGGER.info("Stopping central mail queues: " + n + " queue" + (n == 1 ? "" : "s") + " with " + n2 + " mail" + (n2 == 1 ? "" : "s"));
            }
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        try {
            while (!SENDER_THREAD_POOL.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error stopping mail queue", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        return EChange.CHANGED;
    }
}

