/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.failed;

import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import com.helger.smtp.transport.ESMTPErrorCode;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.MailTransportError;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedMailDataMicroTypeConverter
implements IMicroTypeConverter<FailedMailData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedMailDataMicroTypeConverter.class);
    private static final String ATTR_ID = "id";
    private static final String ATTR_ERRORDT = "errordt";
    private static final String ATTR_ORIGINALSENT_DT = "originalsentdt";
    private static final String ELEMENT_SMTP_SETTINGS = "smtpsettings";
    private static final String ELEMENT_EMAIL_DATA = "emaildata";
    private static final String ELEMENT_ERROR_MSG = "errormsg";
    private static final String ELEMENT_DETAILS = "details";
    private static final String ATTR_ADDRESS_VALID = "addressvalid";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_COMMAND = "command";
    private static final String ATTR_ERROR_MESSAGE = "errormsg";
    private static final String ATTR_ERROR_CODE = "errcode";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull FailedMailData failedMailData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, failedMailData.getID());
        microElement.setAttributeWithConversion(ATTR_ERRORDT, (Object)failedMailData.getErrorDateTime());
        microElement.setAttributeWithConversion(ATTR_ORIGINALSENT_DT, (Object)failedMailData.getOriginalSentDateTime());
        microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)failedMailData.getSMTPSettings(), (String)string, (String)ELEMENT_SMTP_SETTINGS));
        microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)failedMailData.getEmailData(), (String)string, (String)ELEMENT_EMAIL_DATA));
        MailTransportError mailTransportError = failedMailData.getTransportError();
        if (mailTransportError != null) {
            microElement.addElementNS(string, "errormsg").addText((CharSequence)mailTransportError.getThrowable().getMessage());
            for (MailSendDetails mailSendDetails : mailTransportError.getAllDetails()) {
                ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)microElement.addElementNS(string, ELEMENT_DETAILS).setAttribute(ATTR_ADDRESS_VALID, mailSendDetails.isAddressValid())).setAttribute(ATTR_ADDRESS, mailSendDetails.getAddress())).setAttribute(ATTR_COMMAND, mailSendDetails.getCommand())).setAttribute("errormsg", mailSendDetails.getErrorMessage())).setAttribute(ATTR_ERROR_CODE, mailSendDetails.getErrorCode().getECode());
            }
        }
        return microElement;
    }

    @Nullable
    public FailedMailData convertToNative(@Nonnull IMicroElement iMicroElement) {
        IMicroElement iMicroElement2;
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        if (string == null) {
            LOGGER.error("Failed to read ID");
            return null;
        }
        String string2 = iMicroElement.getAttributeValue(ATTR_ERRORDT);
        if (string2 == null) {
            LOGGER.error("Failed to read error date/time");
            return null;
        }
        LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD((String)string2);
        if (localDateTime == null) {
            localDateTime = (LocalDateTime)TypeConverter.convert((Object)string2, LocalDateTime.class);
        }
        if (localDateTime == null) {
            LOGGER.error("Failed to parse error date '" + string2 + "'");
            return null;
        }
        String string3 = iMicroElement.getAttributeValue(ATTR_ORIGINALSENT_DT);
        LocalDateTime localDateTime2 = null;
        if (string3 != null && (localDateTime2 = PDTWebDateHelper.getLocalDateTimeFromXSD((String)string3)) == null) {
            localDateTime2 = (LocalDateTime)TypeConverter.convert((Object)string3, LocalDateTime.class);
        }
        if ((iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_SMTP_SETTINGS)) == null) {
            LOGGER.error("Failed to get child element of SMTP settings!");
            return null;
        }
        ISMTPSettings iSMTPSettings = (ISMTPSettings)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement2, SMTPSettings.class);
        IMicroElement iMicroElement3 = iMicroElement.getFirstChildElement(ELEMENT_EMAIL_DATA);
        IMutableEmailData iMutableEmailData = (IMutableEmailData)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement3, EmailData.class);
        String string4 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)"errormsg");
        Exception exception = StringHelper.isEmpty((String)string4) ? null : new Exception(string4);
        MailTransportError mailTransportError = null;
        if (exception != null) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_DETAILS)) {
                boolean bl = StringParser.parseBool((String)iMicroElement4.getAttributeValue(ATTR_ADDRESS_VALID));
                String string5 = iMicroElement4.getAttributeValue(ATTR_ADDRESS);
                String string6 = iMicroElement4.getAttributeValue(ATTR_COMMAND);
                String string7 = iMicroElement4.getAttributeValue("errormsg");
                int n = StringParser.parseInt((String)iMicroElement4.getAttributeValue(ATTR_ERROR_CODE), (int)-1);
                ESMTPErrorCode eSMTPErrorCode = ESMTPErrorCode.getFromIDOrDefault(n, ESMTPErrorCode.FALLBACK);
                commonsArrayList.add((Object)new MailSendDetails(bl, string5, string6, string7, eSMTPErrorCode));
            }
            mailTransportError = new MailTransportError(exception, (Iterable<? extends MailSendDetails>)commonsArrayList);
        }
        return new FailedMailData(string, localDateTime, iSMTPSettings, localDateTime2, iMutableEmailData, mailTransportError);
    }
}

