/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.failed;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.email.IEmailAddress;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ITypedObject;
import com.helger.base.type.ObjectType;
import com.helger.datetime.helper.PDTFactory;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailTransportError;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

@Immutable
public class FailedMailData
implements ITypedObject<String> {
    public static final ObjectType TYPE_FAILEDMAIL = new ObjectType("failedmail");
    private final String m_sID;
    private final LocalDateTime m_aErrorDT;
    private final ISMTPSettings m_aSettings;
    private final LocalDateTime m_aOriginalSentDateTime;
    private final IMutableEmailData m_aEmailData;
    private final MailTransportError m_aError;

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull MailTransportError mailTransportError) {
        this(iSMTPSettings, null, mailTransportError);
    }

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nullable IMutableEmailData iMutableEmailData) {
        this(iSMTPSettings, iMutableEmailData, null);
    }

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nullable IMutableEmailData iMutableEmailData, @Nullable MailTransportError mailTransportError) {
        this(GlobalIDFactory.getNewPersistentStringID(), PDTFactory.getCurrentLocalDateTimeMillisOnly(), iSMTPSettings, iMutableEmailData == null ? null : iMutableEmailData.getSentDateTime(), iMutableEmailData, mailTransportError);
    }

    public FailedMailData(@Nonnull String string, @Nonnull LocalDateTime localDateTime, @Nonnull ISMTPSettings iSMTPSettings, @Nullable LocalDateTime localDateTime2, @Nullable IMutableEmailData iMutableEmailData, @Nullable MailTransportError mailTransportError) {
        this.m_sID = (String)ValueEnforcer.notNull((Object)string, (String)"ID");
        this.m_aErrorDT = (LocalDateTime)ValueEnforcer.notNull((Object)localDateTime, (String)"ErrorDT");
        this.m_aSettings = (ISMTPSettings)ValueEnforcer.notNull((Object)iSMTPSettings, (String)"Settings");
        this.m_aOriginalSentDateTime = localDateTime2 != null ? localDateTime2 : (iMutableEmailData != null ? iMutableEmailData.getSentDateTime() : null);
        this.m_aEmailData = iMutableEmailData;
        this.m_aError = mailTransportError;
    }

    @Nonnull
    public ObjectType getObjectType() {
        return TYPE_FAILEDMAIL;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public LocalDateTime getErrorDateTime() {
        return this.m_aErrorDT;
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSettings;
    }

    @Nullable
    public LocalDateTime getOriginalSentDateTime() {
        return this.m_aOriginalSentDateTime;
    }

    @Nullable
    public IMutableEmailData getEmailData() {
        return this.m_aEmailData;
    }

    @Nullable
    public MailTransportError getTransportError() {
        return this.m_aError;
    }

    public boolean hasTransportError() {
        return this.m_aError != null;
    }

    @Nullable
    public Throwable getTransportThrowable() {
        return this.m_aError == null ? null : this.m_aError.getThrowable();
    }

    @Nonnull
    public String getSMTPServerDisplayText() {
        StringBuilder stringBuilder = new StringBuilder().append(this.m_aSettings.getHostName());
        if (this.m_aSettings.hasPort()) {
            stringBuilder.append(":").append(this.m_aSettings.getPort());
        }
        if (this.m_aSettings.hasUserName()) {
            stringBuilder.append("[").append(this.m_aSettings.getUserName());
            if (this.m_aSettings.hasPassword()) {
                stringBuilder.append("/****");
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public String getSenderDisplayText() {
        return this.m_aEmailData == null ? "" : this.m_aEmailData.getFrom().getDisplayName();
    }

    @Nonnull
    public String getRecipientDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_aEmailData != null) {
            for (IEmailAddress iEmailAddress : this.m_aEmailData.to()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(iEmailAddress.getDisplayName());
            }
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getTransportThrowableMessage() {
        return this.m_aError == null ? null : this.m_aError.getThrowable().getMessage();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FailedMailData failedMailData = (FailedMailData)object;
        return this.m_sID.equals(failedMailData.m_sID) && this.m_aErrorDT.equals(failedMailData.m_aErrorDT) && this.m_aSettings.equals(failedMailData.m_aSettings) && EqualsHelper.equals((Object)this.m_aOriginalSentDateTime, (Object)failedMailData.m_aOriginalSentDateTime) && EqualsHelper.equals((Object)this.m_aEmailData, (Object)failedMailData.m_aEmailData) && EqualsHelper.equals((Object)this.getTransportThrowableMessage(), (Object)failedMailData.getTransportThrowableMessage());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_aErrorDT).append((Object)this.m_aSettings).append((Object)this.m_aOriginalSentDateTime).append((Object)this.m_aEmailData).append((Object)this.getTransportThrowableMessage()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("id", (Object)this.m_sID).append("errorDateTime", (Object)this.m_aErrorDT).append("settings", (Object)this.m_aSettings).appendIfNotNull("originalSentDateTime", (Object)this.m_aOriginalSentDateTime).appendIfNotNull("emailData", (Object)this.m_aEmailData).appendIfNotNull("error", (Object)this.m_aError).getToString();
    }
}

