/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.annotation.misc.ContainsSoftMigration;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.codec.base64.Base64;
import com.helger.base.io.stream.StreamHelper;
import com.helger.smtp.data.EEmailAttachmentDisposition;
import com.helger.smtp.data.EmailAttachment;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.activation.FileTypeMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class EmailAttachmentMicroTypeConverter
implements IMicroTypeConverter<EmailAttachment> {
    private static final String ATTR_FILENAME = "filename";
    private static final String ATTR_CHARSET = "charset";
    private static final String ATTR_DISPOSITION = "disposition";
    private static final String ATTR_CONTENT_TYPE = "contenttype";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull EmailAttachment emailAttachment, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_FILENAME, emailAttachment.getFilename());
        if (emailAttachment.hasCharset()) {
            microElement.setAttribute(ATTR_CHARSET, emailAttachment.getCharset().name());
        }
        microElement.setAttribute(ATTR_DISPOSITION, emailAttachment.getDisposition().getID());
        microElement.setAttribute(ATTR_CONTENT_TYPE, emailAttachment.getContentType());
        byte[] byArray = StreamHelper.getAllBytes((InputStream)emailAttachment.getInputStream());
        if (byArray != null) {
            microElement.addText((CharSequence)Base64.encodeBytes((byte[])byArray));
        }
        return microElement;
    }

    @Nonnull
    @ContainsSoftMigration
    public EmailAttachment convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string;
        EEmailAttachmentDisposition eEmailAttachmentDisposition;
        String string2 = iMicroElement.getAttributeValue(ATTR_FILENAME);
        String string3 = iMicroElement.getAttributeValue(ATTR_CHARSET);
        Charset charset = string3 == null ? null : CharsetHelper.getCharsetFromName((String)string3);
        String string4 = iMicroElement.getAttributeValue(ATTR_CONTENT_TYPE);
        if (string4 == null) {
            string4 = FileTypeMap.getDefaultFileTypeMap().getContentType(string2);
        }
        if ((eEmailAttachmentDisposition = EEmailAttachmentDisposition.getFromIDOrNull(string = iMicroElement.getAttributeValue(ATTR_DISPOSITION))) == null) {
            eEmailAttachmentDisposition = EmailAttachment.DEFAULT_DISPOSITION;
        }
        byte[] byArray = Base64.safeDecode((String)iMicroElement.getTextContent());
        return new EmailAttachment(string2, byArray, charset, string4, eEmailAttachmentDisposition);
    }
}

