/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.system.SystemProperties;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.smtp.listener.IEmailDataTransportListener;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.event.ConnectionListener;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EmailGlobalSettings {
    public static final int DEFAULT_MAX_QUEUE_LENGTH = 500;
    public static final int DEFAULT_MAX_SEND_COUNT = 100;
    public static final boolean DEFAULT_USE_SSL = false;
    public static final boolean DEFAULT_USE_STARTTLS = false;
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLISECS = 5000L;
    public static final long DEFAULT_TIMEOUT_MILLISECS = 10000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailGlobalSettings.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static int s_nMaxMailQueueLen = 500;
    @GuardedBy(value="RW_LOCK")
    private static int s_nMaxMailSendCount = 100;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseSSL = false;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseSTARTTLS = false;
    @GuardedBy(value="RW_LOCK")
    private static long s_nConnectionTimeoutMilliSecs = 5000L;
    @GuardedBy(value="RW_LOCK")
    private static long s_nTimeoutMilliSecs = 10000L;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bDebugSMTP = GlobalDebug.isDebugMode();
    @GuardedBy(value="RW_LOCK")
    private static ICommonsList<ConnectionListener> s_aConnectionListeners = new CommonsArrayList();
    @GuardedBy(value="RW_LOCK")
    private static ICommonsList<IEmailDataTransportListener> s_aEmailDataTransportListeners = new CommonsArrayList();

    private EmailGlobalSettings() {
    }

    @Nonnegative
    public static int getMaxMailQueueLength() {
        return RW_LOCK.readLockedInt(() -> s_nMaxMailQueueLen);
    }

    @Nonnegative
    public static int getMaxMailSendCount() {
        return RW_LOCK.readLockedInt(() -> s_nMaxMailSendCount);
    }

    @Nonnull
    public static EChange setMailQueueSize(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0((int)n, (String)"MaxMailQueueLen");
        ValueEnforcer.isGT0((int)n2, (String)"MaxMailSendCount");
        ValueEnforcer.isTrue((n >= n2 ? 1 : 0) != 0, () -> "MaxMailQueueLen (" + n + ") must be >= than MaxMailSendCount (" + n2 + ")");
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (n == s_nMaxMailQueueLen && n2 == s_nMaxMailSendCount) {
                return EChange.UNCHANGED;
            }
            s_nMaxMailQueueLen = n;
            s_nMaxMailSendCount = n2;
            return EChange.CHANGED;
        });
    }

    public static boolean isUseSSL() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseSSL);
    }

    @Nonnull
    public static EChange setUseSSL(boolean bl) {
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bUseSSL == bl) {
                return EChange.UNCHANGED;
            }
            s_bUseSSL = bl;
            return EChange.CHANGED;
        });
    }

    public static boolean isUseSTARTTLS() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseSTARTTLS);
    }

    @Nonnull
    public static EChange setUseSTARTTLS(boolean bl) {
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bUseSTARTTLS == bl) {
                return EChange.UNCHANGED;
            }
            s_bUseSTARTTLS = bl;
            return EChange.CHANGED;
        });
    }

    @CheckForSigned
    public static long getConnectionTimeoutMilliSecs() {
        return RW_LOCK.readLockedLong(() -> s_nConnectionTimeoutMilliSecs);
    }

    @Nonnull
    public static EChange setConnectionTimeoutMilliSecs(long l) {
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_nConnectionTimeoutMilliSecs == l) {
                return EChange.UNCHANGED;
            }
            if (l <= 0L) {
                LOGGER.warn("You are setting an indefinite connection timeout for the mail transport api: " + l);
            }
            s_nConnectionTimeoutMilliSecs = l;
            return EChange.CHANGED;
        });
    }

    @CheckForSigned
    public static long getTimeoutMilliSecs() {
        return RW_LOCK.readLockedLong(() -> s_nTimeoutMilliSecs);
    }

    @Nonnull
    public static EChange setTimeoutMilliSecs(long l) {
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_nTimeoutMilliSecs == l) {
                return EChange.UNCHANGED;
            }
            if (l <= 0L) {
                LOGGER.warn("You are setting an indefinite socket timeout for the mail transport api: " + l);
            }
            s_nTimeoutMilliSecs = l;
            return EChange.CHANGED;
        });
    }

    public static boolean isDebugSMTP() {
        return RW_LOCK.readLockedBoolean(() -> s_bDebugSMTP);
    }

    @Nonnull
    public static EChange setDebugSMTP(boolean bl) {
        return (EChange)RW_LOCK.writeLockedGet(() -> {
            if (s_bDebugSMTP == bl) {
                return EChange.UNCHANGED;
            }
            s_bDebugSMTP = bl;
            return EChange.CHANGED;
        });
    }

    public static void addConnectionListener(@Nonnull ConnectionListener connectionListener) {
        ValueEnforcer.notNull((Object)connectionListener, (String)"ConnectionListener");
        RW_LOCK.writeLockedBoolean(() -> s_aConnectionListeners.add((Object)connectionListener));
    }

    @Nonnull
    public static EChange removeConnectionListener(@Nullable ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aConnectionListeners.removeObject((Object)connectionListener));
    }

    @Nonnull
    public static EChange removeAllConnectionListeners() {
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aConnectionListeners.removeAll());
    }

    public static boolean hasConnectionListeners() {
        return RW_LOCK.readLockedBoolean(() -> s_aConnectionListeners.isNotEmpty());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ConnectionListener> getAllConnectionListeners() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> s_aConnectionListeners.getClone());
    }

    public static void addEmailDataTransportListener(@Nonnull IEmailDataTransportListener iEmailDataTransportListener) {
        ValueEnforcer.notNull((Object)iEmailDataTransportListener, (String)"EmailDataTransportListener");
        RW_LOCK.writeLockedBoolean(() -> s_aEmailDataTransportListeners.add((Object)iEmailDataTransportListener));
    }

    @Nonnull
    public static EChange removeEmailDataTransportListener(@Nullable IEmailDataTransportListener iEmailDataTransportListener) {
        if (iEmailDataTransportListener == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aEmailDataTransportListeners.removeObject((Object)iEmailDataTransportListener));
    }

    @Nonnull
    public static EChange removeAllEmailDataTransportListeners() {
        return (EChange)RW_LOCK.writeLockedGet(() -> s_aEmailDataTransportListeners.removeAll());
    }

    public static boolean hasEmailDataTransportListeners() {
        return RW_LOCK.readLockedBoolean(() -> s_aEmailDataTransportListeners.isNotEmpty());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IEmailDataTransportListener> getAllEmailDataTransportListeners() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> s_aEmailDataTransportListeners.getClone());
    }

    public static void enableJavaxMailDebugging(boolean bl) {
        java.util.logging.Logger.getLogger("com.sun.mail.smtp").setLevel(bl ? Level.FINEST : Level.INFO);
        java.util.logging.Logger.getLogger("com.sun.mail.smtp.protocol").setLevel(bl ? Level.FINEST : Level.INFO);
        SystemProperties.setPropertyValue((String)"mail.socket.debug", (boolean)bl);
        SystemProperties.setPropertyValue((String)"java.security.debug", (String)(bl ? "certpath" : null));
        SystemProperties.setPropertyValue((String)"javax.net.debug", (String)(bl ? "trustmanager" : null));
    }

    public static boolean isJavaxMailDebuggingEnabled() {
        return java.util.logging.Logger.getLogger("com.sun.mail.smtp").getLevel().equals(Level.FINEST);
    }

    public static void setToDefault() {
        RW_LOCK.writeLocked(() -> {
            s_nMaxMailQueueLen = 500;
            s_nMaxMailSendCount = 100;
            s_bUseSSL = false;
            s_bUseSTARTTLS = false;
            s_nConnectionTimeoutMilliSecs = 5000L;
            s_nTimeoutMilliSecs = 10000L;
            s_bDebugSMTP = GlobalDebug.isDebugMode();
            s_aConnectionListeners.clear();
            s_aEmailDataTransportListeners.clear();
        });
    }
}

