/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.codec.IDecoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemHelper;
import com.helger.base.url.URLHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.collection.enumeration.EnumerationHelper;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mime.IMimeType;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.mock.MockHttpListener;
import com.helger.servlet.mock.MockHttpSession;
import com.helger.servlet.mock.MockRequestDispatcher;
import com.helger.servlet.mock.MockServletInputStream;
import com.helger.servlet.request.RequestHelper;
import com.helger.text.locale.IHasLocale;
import com.helger.url.SimpleURLHelper;
import com.helger.url.codec.URLParameterDecoder;
import com.helger.url.param.URLParameter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockHttpServletRequest
implements HttpServletRequest,
IHasLocale {
    public static final boolean DEFAULT_INVOKE_HTTP_LISTENER = true;
    public static final String DEFAULT_PROTOCOL = EHttpVersion.HTTP_11.getName();
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = SchemeDefaultPortMapper.getDefaultPortOrThrow((String)"http");
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    public static final EHttpMethod DEFAULT_METHOD = EHttpMethod.GET;
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServletRequest.class);
    private boolean m_bInvalidated = false;
    private boolean m_bActive = true;
    private final ICommonsMap<String, Object> m_aAttributes = new CommonsHashMap();
    private Charset m_aCharacterEncoding;
    private byte[] m_aContent;
    private String m_sContentType;
    private final ICommonsList<URLParameter> m_aParameters = new CommonsArrayList();
    private String m_sProtocol = DEFAULT_PROTOCOL;
    private String m_sScheme = "http";
    private String m_sServerName = "localhost";
    private int m_nServerPort = DEFAULT_SERVER_PORT;
    private final ICommonsList<Locale> m_aLocales = new CommonsArrayList();
    private boolean m_bSecure = false;
    private final ServletContext m_aServletContext;
    private String m_sRemoteAddr = "127.0.0.1";
    private String m_sRemoteHost = "localhost";
    private int m_nRemotePort = DEFAULT_SERVER_PORT;
    private String m_sLocalName = "localhost";
    private String m_sLocalAddr = "127.0.0.1";
    private int m_nLocalPort = DEFAULT_SERVER_PORT;
    private String m_sAuthType;
    private Cookie[] m_aCookies;
    private final HttpHeaderMap m_aHeaders = new HttpHeaderMap();
    private EHttpMethod m_eMethod;
    private String m_sPathInfo;
    private String m_sContextPath = "";
    private String m_sQueryString;
    private String m_sRemoteUser;
    private final ICommonsSet<String> m_aUserRoles = new CommonsHashSet();
    private Principal m_aUserPrincipal;
    private String m_sRequestURI;
    private String m_sServletPath = "";
    private HttpSession m_aSession;
    private String m_sSessionID;
    private boolean m_bRequestedSessionIDValid = true;
    private boolean m_bRequestedSessionIDFromCookie = true;
    private boolean m_bRequestedSessionIDFromURL = false;

    public MockHttpServletRequest() {
        this(null, DEFAULT_METHOD, false);
    }

    public MockHttpServletRequest(@Nullable ServletContext servletContext) {
        this(servletContext, DEFAULT_METHOD, true);
    }

    public MockHttpServletRequest(@Nullable ServletContext servletContext, @Nullable EHttpMethod eHttpMethod) {
        this(servletContext, eHttpMethod, true);
    }

    public MockHttpServletRequest(@Nullable ServletContext servletContext, @Nullable EHttpMethod eHttpMethod, boolean bl) {
        this.m_aServletContext = servletContext;
        this.setMethod(eHttpMethod);
        this.m_aLocales.add((Object)Locale.ENGLISH);
        this.addHeader("User-Agent", this.getClass().getName());
        this.addHeader("Accept-Encoding", "*, gzip;q=0, x-gzip;q=0, deflate;q=0, compress;q=0, x-compress;q=0");
        this.addHeader("Accept-Charset", "*");
        if (servletContext != null && bl) {
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(servletContext, (ServletRequest)this);
            for (ServletRequestListener servletRequestListener : MockHttpListener.getAllServletRequestListeners()) {
                servletRequestListener.requestInitialized(servletRequestEvent);
            }
        }
    }

    @Nonnull
    public final ServletContext getServletContext() {
        if (this.m_aServletContext == null) {
            throw new IllegalStateException("No servlet context present!");
        }
        return this.m_aServletContext;
    }

    public boolean isActive() {
        return this.m_bActive;
    }

    public void close() {
        this.m_bActive = false;
    }

    public void invalidate() {
        if (this.m_bInvalidated) {
            throw new IllegalStateException("Request scope already invalidated!");
        }
        this.m_bInvalidated = true;
        if (this.m_aServletContext != null) {
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(this.m_aServletContext, (ServletRequest)this);
            for (ServletRequestListener servletRequestListener : MockHttpListener.getAllServletRequestListeners()) {
                servletRequestListener.requestDestroyed(servletRequestEvent);
            }
        }
        this.close();
        this.clearAttributes();
    }

    protected void checkActive() {
        if (!this.m_bActive) {
            throw new IllegalStateException("Request is not active anymore");
        }
    }

    @Nullable
    public Object getAttribute(@Nullable String string) {
        this.checkActive();
        return this.m_aAttributes.get((Object)string);
    }

    @Nonnull
    public Enumeration<String> getAttributeNames() {
        this.checkActive();
        return EnumerationHelper.getEnumeration((Iterable)this.m_aAttributes.keySet());
    }

    public void setCharacterEncoding(@Nullable String string) {
        this.setCharacterEncoding(string == null ? null : CharsetHelper.getCharsetFromName((String)string));
    }

    public void setCharacterEncoding(@Nullable Charset charset) {
        this.m_aCharacterEncoding = charset;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.m_aCharacterEncoding == null ? null : this.m_aCharacterEncoding.name();
    }

    @Nullable
    public Charset getCharacterEncodingObj() {
        return this.m_aCharacterEncoding;
    }

    @Nonnull
    public Charset getCharacterEncodingObjOrDefault() {
        Charset charset = this.getCharacterEncodingObj();
        if (charset == null) {
            charset = SystemHelper.getSystemCharset();
        }
        return charset;
    }

    @Nonnull
    public MockHttpServletRequest setContent(@Nullable byte[] byArray) {
        this.m_aContent = ArrayHelper.getCopy((byte[])byArray);
        this.removeHeader("Content-Length");
        this.addHeader("Content-Length", Integer.toString(this.m_aContent.length));
        return this;
    }

    @CheckForSigned
    public int getContentLength() {
        return this.m_aContent != null ? this.m_aContent.length : -1;
    }

    @Nonnull
    public MockHttpServletRequest setContentType(@Nullable IMimeType iMimeType) {
        return this.setContentType(iMimeType == null ? null : iMimeType.getAsString());
    }

    @Nonnull
    public MockHttpServletRequest setContentType(@Nullable String string) {
        this.m_sContentType = string;
        this.removeHeader("Content-Type");
        if (string != null) {
            this.addHeader("Content-Type", string);
        }
        return this;
    }

    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nullable
    public ServletInputStream getInputStream() {
        if (this.m_aContent == null) {
            return null;
        }
        return new MockServletInputStream(this.m_aContent);
    }

    @Nonnull
    public MockHttpServletRequest setParameter(@Nonnull String string, @Nullable String string2) {
        this.m_aParameters.removeIf(uRLParameter -> uRLParameter.hasName(string));
        this.m_aParameters.add((Object)new URLParameter(string, string2));
        return this;
    }

    @Nonnull
    public MockHttpServletRequest setParameter(@Nonnull String string, @Nullable String[] stringArray) {
        this.m_aParameters.removeIf(uRLParameter -> uRLParameter.hasName(string));
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.m_aParameters.add((Object)new URLParameter(string, string2));
            }
        }
        return this;
    }

    @Nonnull
    public MockHttpServletRequest setParameters(@Nullable ICommonsList<URLParameter> iCommonsList) {
        if (iCommonsList != null) {
            for (URLParameter uRLParameter : iCommonsList) {
                this.m_aParameters.removeIf(uRLParameter2 -> uRLParameter2.hasName(uRLParameter.getName()));
            }
            this.m_aParameters.addAll(iCommonsList);
        }
        return this;
    }

    @Nonnull
    public final MockHttpServletRequest addParameter(@Nonnull String string, @Nullable String string2) {
        this.m_aParameters.add((Object)new URLParameter(string, StringHelper.getNotNull((String)string2)));
        return this;
    }

    @Nonnull
    public final MockHttpServletRequest addParameter(@Nonnull String string, @Nullable String[] stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.m_aParameters.add((Object)new URLParameter(string, string2));
            }
        }
        return this;
    }

    @Nonnull
    public MockHttpServletRequest addParameters(@Nullable List<? extends URLParameter> list) {
        this.m_aParameters.addAll(list);
        return this;
    }

    @Nonnull
    public MockHttpServletRequest removeParameter(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_aParameters.removeIf(uRLParameter -> uRLParameter.hasName(string));
        return this;
    }

    @Nonnull
    public MockHttpServletRequest removeAllParameters() {
        this.m_aParameters.removeAll();
        return this;
    }

    @Nullable
    public String getParameter(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        return (String)this.m_aParameters.findFirstMapped(uRLParameter -> uRLParameter.hasName(string), URLParameter::getValue);
    }

    @Nonnull
    public Enumeration<String> getParameterNames() {
        return EnumerationHelper.getEnumeration((Iterable)new CommonsLinkedHashSet(this.m_aParameters, URLParameter::getName));
    }

    @Nullable
    @ReturnsMutableCopy
    public String[] getParameterValues(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        return (String[])this.m_aParameters.getAllMapped(uRLParameter -> uRLParameter.hasName(string), URLParameter::getValue).toArray((Object[])CGlobal.EMPTY_STRING_ARRAY);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String[]> getParameterMap() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (String string : new CommonsLinkedHashSet(this.m_aParameters, URLParameter::getName)) {
            commonsLinkedHashMap.put((Object)string, (Object)this.getParameterValues(string));
        }
        return commonsLinkedHashMap;
    }

    @Nonnull
    public MockHttpServletRequest setProtocol(@Nullable String string) {
        this.m_sProtocol = string;
        return this;
    }

    @Nullable
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Nonnull
    public MockHttpServletRequest setScheme(@Nullable String string) {
        this.m_sScheme = string;
        return this;
    }

    @Nullable
    public String getScheme() {
        return this.m_sScheme;
    }

    @Nonnull
    public MockHttpServletRequest setServerName(@Nullable String string) {
        this.m_sServerName = string;
        return this;
    }

    @Nullable
    public String getServerName() {
        return this.m_sServerName;
    }

    @Nonnull
    public MockHttpServletRequest setServerPort(int n) {
        this.m_nServerPort = n;
        return this;
    }

    public int getServerPort() {
        return this.m_nServerPort;
    }

    @Nullable
    public BufferedReader getReader() {
        if (this.m_aContent == null) {
            return null;
        }
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(this.m_aContent);
        InputStreamReader inputStreamReader = StreamHelper.createReader((InputStream)nonBlockingByteArrayInputStream, (Charset)this.getCharacterEncodingObjOrDefault());
        return new BufferedReader(inputStreamReader);
    }

    @Nonnull
    public MockHttpServletRequest setRemoteAddr(@Nullable String string) {
        this.m_sRemoteAddr = string;
        return this;
    }

    @Nullable
    public String getRemoteAddr() {
        return this.m_sRemoteAddr;
    }

    @Nonnull
    public MockHttpServletRequest setRemoteHost(@Nullable String string) {
        this.m_sRemoteHost = string;
        return this;
    }

    @Nullable
    public String getRemoteHost() {
        return this.m_sRemoteHost;
    }

    public void setAttribute(@Nonnull String string, @Nullable Object object) {
        this.checkActive();
        ValueEnforcer.notNull((Object)string, (String)"Name");
        if (object != null) {
            this.m_aAttributes.put((Object)string, object);
        } else {
            this.m_aAttributes.remove((Object)string);
        }
    }

    public void removeAttribute(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        this.checkActive();
        this.m_aAttributes.remove((Object)string);
    }

    @Nonnull
    public MockHttpServletRequest clearAttributes() {
        this.m_aAttributes.clear();
        return this;
    }

    @Nonnull
    public MockHttpServletRequest addPreferredLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aLocales.add(0, (Object)locale);
        return this;
    }

    @Nonnull
    public Locale getLocale() {
        return (Locale)this.m_aLocales.getFirstOrNull();
    }

    @Nonnull
    @Nonempty
    public Enumeration<Locale> getLocales() {
        return EnumerationHelper.getEnumeration(this.m_aLocales);
    }

    @Nonnull
    public MockHttpServletRequest setSecure(boolean bl) {
        this.m_bSecure = bl;
        return this;
    }

    public boolean isSecure() {
        return this.m_bSecure;
    }

    @Nonnull
    public MockRequestDispatcher getRequestDispatcher(@Nonnull String string) {
        return new MockRequestDispatcher(string);
    }

    @Deprecated(forRemoval=false)
    public String getRealPath(@Nonnull String string) {
        return this.getServletContext().getRealPath(string);
    }

    @Nonnull
    public MockHttpServletRequest setRemotePort(int n) {
        this.m_nRemotePort = n;
        return this;
    }

    public int getRemotePort() {
        return this.m_nRemotePort;
    }

    @Nonnull
    public MockHttpServletRequest setLocalName(@Nullable String string) {
        this.m_sLocalName = string;
        return this;
    }

    @Nullable
    public String getLocalName() {
        return this.m_sLocalName;
    }

    @Nonnull
    public MockHttpServletRequest setLocalAddr(@Nullable String string) {
        this.m_sLocalAddr = string;
        return this;
    }

    @Nullable
    public String getLocalAddr() {
        return this.m_sLocalAddr;
    }

    @Nonnull
    public MockHttpServletRequest setLocalPort(int n) {
        this.m_nLocalPort = n;
        return this;
    }

    public int getLocalPort() {
        return this.m_nLocalPort;
    }

    @Nonnull
    public MockHttpServletRequest setAuthType(@Nullable String string) {
        this.m_sAuthType = string;
        return this;
    }

    @Nullable
    public String getAuthType() {
        return this.m_sAuthType;
    }

    @Nonnull
    public MockHttpServletRequest setCookies(@Nullable Cookie[] cookieArray) {
        this.m_aCookies = (Cookie[])ArrayHelper.getCopy((Object[])cookieArray);
        return this;
    }

    @Nullable
    public Cookie[] getCookies() {
        return (Cookie[])ArrayHelper.getCopy((Object[])this.m_aCookies);
    }

    @Nonnull
    public final MockHttpServletRequest addHeader(@Nullable String string, @Nullable String string2) {
        this.m_aHeaders.addHeader(string, string2);
        return this;
    }

    @Nonnull
    public MockHttpServletRequest removeHeader(@Nullable String string) {
        this.m_aHeaders.removeHeaders(string);
        return this;
    }

    @Deprecated(forRemoval=false)
    public long getDateHeader(@Nullable String string) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=false)
    public int getIntHeader(@Nullable String string) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getHeader(@Nullable String string) {
        ICommonsList iCommonsList = this.m_aHeaders.getAllHeaderValues(string);
        return iCommonsList == null || iCommonsList.isEmpty() ? null : String.valueOf(iCommonsList.iterator().next());
    }

    @Nonnull
    public Enumeration<String> getHeaders(@Nullable String string) {
        ICommonsList iCommonsList = this.m_aHeaders.getAllHeaderValues(string);
        return EnumerationHelper.getEnumeration((Iterable)iCommonsList);
    }

    @Nonnull
    public Enumeration<String> getHeaderNames() {
        return EnumerationHelper.getEnumeration((Iterable)this.m_aHeaders.getAllHeaderNames());
    }

    @Nonnull
    public final MockHttpServletRequest setMethod(@Nullable EHttpMethod eHttpMethod) {
        this.m_eMethod = eHttpMethod;
        return this;
    }

    @Nullable
    public EHttpMethod getMethodEnum() {
        return this.m_eMethod;
    }

    @Nullable
    public String getMethod() {
        return this.m_eMethod == null ? null : this.m_eMethod.getName();
    }

    @Nonnull
    public MockHttpServletRequest setPathInfo(@Nullable String string) {
        this.m_sPathInfo = string;
        return this;
    }

    @Nullable
    public String getPathInfo() {
        return this.m_sPathInfo;
    }

    @Nullable
    public String getPathTranslated() {
        return this.m_sPathInfo != null ? this.getRealPath(this.m_sPathInfo) : null;
    }

    @Nonnull
    public MockHttpServletRequest setContextPath(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string) && !StringHelper.startsWith((CharSequence)string, (char)'/')) {
            LOGGER.error("Illegal context path specified: '" + string + "'");
        }
        this.m_sContextPath = string;
        return this;
    }

    @Nullable
    public String getContextPath() {
        return this.m_sContextPath;
    }

    @Nonnull
    public MockHttpServletRequest setQueryString(@Nullable String string) {
        this.m_sQueryString = string;
        return this;
    }

    @Nullable
    public String getQueryString() {
        return this.m_sQueryString;
    }

    @Nonnull
    public MockHttpServletRequest setRemoteUser(@Nullable String string) {
        this.m_sRemoteUser = string;
        return this;
    }

    @Nullable
    public String getRemoteUser() {
        return this.m_sRemoteUser;
    }

    @Nonnull
    public MockHttpServletRequest addUserRole(@Nullable String string) {
        this.m_aUserRoles.add((Object)string);
        return this;
    }

    public boolean isUserInRole(@Nullable String string) {
        return this.m_aUserRoles.contains((Object)string);
    }

    @Nonnull
    public MockHttpServletRequest setUserPrincipal(@Nullable Principal principal) {
        this.m_aUserPrincipal = principal;
        return this;
    }

    @Nullable
    public Principal getUserPrincipal() {
        return this.m_aUserPrincipal;
    }

    @Nullable
    public String getRequestedSessionId() {
        return this.getSession(true).getId();
    }

    @Nonnull
    public MockHttpServletRequest setRequestURI(@Nullable String string) {
        this.m_sRequestURI = string;
        return this;
    }

    @Nullable
    public String getRequestURI() {
        return this.m_sRequestURI;
    }

    @Nonnull
    public StringBuffer getRequestURL() {
        return new StringBuffer().append((CharSequence)RequestHelper.getFullServerName(this.m_sScheme, this.m_sServerName, this.m_nServerPort)).append(ServletHelper.getRequestRequestURI(this));
    }

    @Nonnull
    public MockHttpServletRequest setServletPath(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string) && !StringHelper.startsWith((CharSequence)string, (char)'/')) {
            LOGGER.error("ServletPath must be empty or start with a slash: '" + string + "'");
        }
        this.m_sServletPath = string;
        return this;
    }

    @Nullable
    public String getServletPath() {
        return this.m_sServletPath;
    }

    @Nonnull
    public MockHttpServletRequest setSessionID(@Nullable String string) {
        this.m_sSessionID = string;
        return this;
    }

    @Nullable
    public String getSessionID() {
        return this.m_sSessionID;
    }

    @Nonnull
    public MockHttpServletRequest setSession(@Nullable HttpSession httpSession) {
        this.m_aSession = httpSession;
        if (httpSession instanceof MockHttpSession) {
            ((MockHttpSession)httpSession).doAccess();
        }
        return this;
    }

    @Nullable
    public HttpSession getSession(boolean bl) {
        this.checkActive();
        if (this.m_aSession instanceof MockHttpSession && ((MockHttpSession)this.m_aSession).isInvalid()) {
            this.m_aSession = null;
        }
        if (this.m_aSession == null && bl) {
            this.m_aSession = new MockHttpSession(this.getServletContext(), this.m_sSessionID);
        }
        if (this.m_aSession instanceof MockHttpSession) {
            ((MockHttpSession)this.m_aSession).doAccess();
        }
        return this.m_aSession;
    }

    @Nonnull
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Nonnull
    public MockHttpServletRequest setRequestedSessionIdValid(boolean bl) {
        this.m_bRequestedSessionIDValid = bl;
        return this;
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_bRequestedSessionIDValid;
    }

    @Nonnull
    public MockHttpServletRequest setRequestedSessionIdFromCookie(boolean bl) {
        this.m_bRequestedSessionIDFromCookie = bl;
        return this;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_bRequestedSessionIDFromCookie;
    }

    @Nonnull
    public MockHttpServletRequest setRequestedSessionIdFromURL(boolean bl) {
        this.m_bRequestedSessionIDFromURL = bl;
        return this;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_bRequestedSessionIDFromURL;
    }

    @Deprecated(forRemoval=false)
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String string, String string2) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public ICommonsCollection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Part getPart(String string) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public MockHttpServletRequest setAllPaths(@Nullable String string) {
        URI uRI;
        if (StringHelper.isNotEmpty((String)string) && (uRI = URLHelper.getAsURI((String)RequestHelper.getWithoutSessionID(string))) != null) {
            String string2;
            this.setScheme(uRI.getScheme());
            this.setSecure("https".equals(uRI.getScheme()));
            this.setServerName(uRI.getHost());
            this.setServerPort(RequestHelper.getServerPortToUse(uRI.getScheme(), uRI.getPort()));
            String string3 = uRI.getPath();
            String string4 = string2 = this.m_aServletContext == null ? "" : this.m_aServletContext.getContextPath();
            if (string2.isEmpty() || StringHelper.startsWith((String)string3, (String)string2)) {
                this.setContextPath(string2);
                string3 = string3.substring(string2.length());
            } else {
                this.setContextPath("");
            }
            int n = string3.indexOf(47, 1);
            if (n >= 0) {
                this.setServletPath(string3.substring(0, n));
                string3 = string3.substring(n);
            } else {
                this.setServletPath(string3);
                string3 = "";
            }
            this.setPathInfo(string3);
            this.setRequestURI(uRI.getRawPath());
            this.setQueryString(uRI.getQuery());
            this.removeAllParameters();
            this.setParameters((ICommonsList<URLParameter>)SimpleURLHelper.getParsedQueryParameters((String)uRI.getQuery(), (IDecoder)new URLParameterDecoder(this.getCharacterEncodingObjOrDefault())));
            return this;
        }
        this.setScheme(null);
        this.setSecure(false);
        this.setServerName(null);
        this.setServerPort(DEFAULT_SERVER_PORT);
        this.setContextPath(null);
        this.setServletPath(null);
        this.setPathInfo(null);
        this.setRequestURI(null);
        this.setQueryString(null);
        this.removeAllParameters();
        return this;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String changeSessionId() {
        this.m_sSessionID = GlobalIDFactory.getNewStringID();
        return this.m_sSessionID;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
        throw new UnsupportedOperationException("upgrade is not supported!");
    }

    public String getRequestId() {
        throw new UnsupportedOperationException();
    }

    public String getProtocolRequestId() {
        throw new UnsupportedOperationException();
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException();
    }
}

