/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.ICommonsList;
import com.helger.servlet.mock.MockEventListenerList;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.EventListener;

@ThreadSafe
public final class MockHttpListener {
    private static final MockEventListenerList DEFAULT_LISTENER = new MockEventListenerList();
    private static final MockEventListenerList CURRENT_LISTENER = new MockEventListenerList();

    private MockHttpListener() {
    }

    public static void addDefaultListener(@Nonnull EventListener eventListener) {
        DEFAULT_LISTENER.addListener(eventListener);
    }

    public static void removeDefaultListeners(@Nonnull Class<? extends EventListener> clazz) {
        DEFAULT_LISTENER.removeListeners(clazz);
    }

    public static void removeAllDefaultListeners() {
        DEFAULT_LISTENER.removeAllListeners();
    }

    public static void setCurrentToDefault() {
        CURRENT_LISTENER.setFrom(DEFAULT_LISTENER);
    }

    public static void addListener(@Nonnull EventListener eventListener) {
        CURRENT_LISTENER.addListener(eventListener);
    }

    public static void removeListeners(@Nonnull Class<? extends EventListener> clazz) {
        CURRENT_LISTENER.removeListeners(clazz);
    }

    public static void removeAllListeners() {
        CURRENT_LISTENER.removeAllListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ServletContextListener> getAllServletContextListeners() {
        return CURRENT_LISTENER.getAllServletContextListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<HttpSessionListener> getAllHttpSessionListeners() {
        return CURRENT_LISTENER.getAllHttpSessionListeners();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ServletRequestListener> getAllServletRequestListeners() {
        return CURRENT_LISTENER.getAllServletRequestListeners();
    }
}

