/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.http;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.servlet.io.AbstractServletOutputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class CountingOnlyServletOutputStream
extends AbstractServletOutputStream {
    private long m_nContentLength = 0L;

    @Nonnegative
    public long getContentLength() {
        return this.m_nContentLength;
    }

    public void write(int n) {
        ++this.m_nContentLength;
    }

    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        this.m_nContentLength += (long)n2;
    }
}

