/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.lang.EnumHelper;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.network.proxy.config.IProxySettingsPerProtocol;
import com.helger.url.protocol.EURLProtocol;
import com.helger.url.protocol.IURLProtocol;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.Proxy;

public enum EHttpProxyType implements IProxySettingsPerProtocol
{
    HTTP("http", (IURLProtocol)EURLProtocol.HTTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http")),
    HTTPS("https", (IURLProtocol)EURLProtocol.HTTPS, SchemeDefaultPortMapper.getDefaultPortOrThrow("https")),
    FTP("ftp", (IURLProtocol)EURLProtocol.FTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http"));

    private final String m_sID;
    private final IURLProtocol m_aURLProtocol;
    private final int m_nDefaultPort;

    private EHttpProxyType(@Nonnegative String string2, IURLProtocol iURLProtocol, int n2) {
        this.m_sID = string2;
        this.m_aURLProtocol = iURLProtocol;
        this.m_nDefaultPort = n2;
    }

    @Nonnull
    public Proxy.Type getProxyType() {
        return Proxy.Type.HTTP;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public IURLProtocol getURLProtocol() {
        return this.m_aURLProtocol;
    }

    @Override
    @Nonnegative
    public int getDefaultPort() {
        return this.m_nDefaultPort;
    }

    @Override
    @Nonnull
    public String getPropertyNameNoProxyHosts() {
        if (this == HTTPS) {
            return HTTP.getPropertyNameNoProxyHosts();
        }
        return this.m_sID + ".noProxyHosts";
    }

    @Nullable
    public static EHttpProxyType getFromIDOrNull(@Nullable String string) {
        return (EHttpProxyType)EnumHelper.getFromIDOrNull(EHttpProxyType.class, (Object)string);
    }

    @Nullable
    public static EHttpProxyType getFromURLProtocolOrDefault(@Nullable IURLProtocol iURLProtocol, @Nullable EHttpProxyType eHttpProxyType2) {
        return (EHttpProxyType)EnumHelper.findFirst(EHttpProxyType.class, eHttpProxyType -> eHttpProxyType.m_aURLProtocol.equals((Object)iURLProtocol), (Enum)eHttpProxyType2);
    }
}

