/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.autoconf;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.base.timing.StopWatch;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.dns.resolve.DNSResolver;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.network.proxy.settings.IProxySettings;
import com.helger.network.proxy.settings.ProxySettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyAutoConfigHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyAutoConfigHelper.class);
    public static final Charset DEFAULT_SCRIPT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final ScriptEngine SCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("nashorn");
    private final IReadableResource m_aPACRes;
    private final String m_sPACCode;

    public ProxyAutoConfigHelper(@Nonnull IReadableResource iReadableResource) throws ScriptException {
        this.m_aPACRes = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"PACResource");
        this.m_sPACCode = null;
        if (SCRIPT_ENGINE != null) {
            SCRIPT_ENGINE.eval(this.m_aPACRes.getReader(DEFAULT_SCRIPT_CHARSET));
        }
    }

    public ProxyAutoConfigHelper(@Nonnull String string) throws ScriptException {
        this.m_aPACRes = null;
        this.m_sPACCode = (String)ValueEnforcer.notNull((Object)string, (String)"PACCode");
        if (SCRIPT_ENGINE != null) {
            SCRIPT_ENGINE.eval(this.m_sPACCode);
        }
    }

    public static boolean isNashornScriptEngineAvailable() {
        return SCRIPT_ENGINE != null;
    }

    @Nullable
    public String findProxyForURL(@Nonnull String string, @Nonnull String string2) throws ScriptException {
        if (SCRIPT_ENGINE == null) {
            LOGGER.warn("Because no Nashorn ScriptEngine could be created, no proxy can be found");
            return null;
        }
        Object object = SCRIPT_ENGINE.eval("findProxyForURL('" + string + "', '" + string2 + "')");
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Nonnull
    public ICommonsList<IProxySettings> getProxyListForURL(@Nonnull URI uRI) throws ScriptException {
        return this.getProxyListForURL(uRI.toString(), uRI.getHost());
    }

    @Nonnull
    public ICommonsList<IProxySettings> getProxyListForURL(@Nonnull String string, @Nonnull String string2) throws ScriptException {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        String string3 = this.findProxyForURL(string, string2);
        if (string3 != null && (string3 = string3.trim()).length() > 0) {
            for (String string4 : StringHelper.getExploded((char)';', (String)string3)) {
                String[] stringArray;
                boolean bl = true;
                if ((string4 = string4.trim()).equals("DIRECT")) {
                    commonsArrayList.add((Object)ProxySettings.createNoProxySettings());
                    bl = false;
                } else if (string4.startsWith("PROXY")) {
                    stringArray = StringHelper.getExplodedArray((char)' ', (String)string4, (int)2);
                    if (stringArray.length == 2 && (stringArray = StringHelper.getExplodedArray((char)':', (String)stringArray[1], (int)2)).length == 2) {
                        var9_9 = stringArray[0];
                        var10_10 = stringArray[1];
                        var11_11 = StringParser.parseInt((String)var10_10, (int)-1);
                        commonsArrayList.add((Object)new ProxySettings(Proxy.Type.HTTP, var9_9, var11_11));
                        bl = false;
                    }
                } else if (string4.startsWith("SOCKS") && (stringArray = StringHelper.getExplodedArray((char)' ', (String)string4, (int)2)).length == 2 && (stringArray = StringHelper.getExplodedArray((char)':', (String)stringArray[1], (int)2)).length == 2) {
                    var9_9 = stringArray[0];
                    var10_10 = stringArray[1];
                    var11_11 = StringParser.parseInt((String)var10_10, (int)1080);
                    commonsArrayList.add((Object)new ProxySettings(Proxy.Type.SOCKS, var9_9, var11_11));
                    bl = false;
                }
                if (!bl) continue;
                LOGGER.warn("Found unknown proxy directive '" + string4 + "'");
            }
        }
        return commonsArrayList;
    }

    static {
        if (SCRIPT_ENGINE == null) {
            LOGGER.warn("Failed to create Nashorn ScriptEngine");
        } else {
            try {
                StopWatch stopWatch = StopWatch.createdStarted();
                SCRIPT_ENGINE.eval("var dnsResolve = function(hostName){ return " + DNSResolver.class.getName() + ".dnsResolve(hostName); }");
                SCRIPT_ENGINE.eval("var dnsResolveEx = function(hostName){ return " + DNSResolver.class.getName() + ".dnsResolveEx(hostName); }");
                SCRIPT_ENGINE.eval("var myIpAddress = function(){ return " + DNSResolver.class.getName() + ".getMyIpAddress(); }");
                SCRIPT_ENGINE.eval(new ClassPathResource("proxy-js/pac-utils.js").getReader(DEFAULT_SCRIPT_CHARSET));
                long l = stopWatch.stopAndGetMillis();
                if (l > 100L) {
                    LOGGER.info("Initial ProxyAutoConfig (PAC) Nashorn script compilation took " + l + " ms");
                }
            }
            catch (ScriptException scriptException) {
                throw new InitializationException("Failed to init ProxyAutoConfig (PAC) Nashorn script!", (Throwable)scriptException);
            }
        }
    }
}

