/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.mail.cte.IContentTransferEncoding;
import com.helger.mail.datasource.IExtendedDataSource;
import jakarta.activation.DataSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.EncodingAware;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface IEncodingAwareDataSource
extends IExtendedDataSource,
EncodingAware {
    @Nullable
    public IContentTransferEncoding getContentTransferEncoding();

    @Nullable
    default public String getEncoding() {
        IContentTransferEncoding iContentTransferEncoding = this.getContentTransferEncoding();
        return iContentTransferEncoding == null ? null : (String)iContentTransferEncoding.getID();
    }

    @Nonnull
    public static IEncodingAwareDataSource getEncodingAware(final @Nonnull DataSource dataSource, final @Nullable IContentTransferEncoding iContentTransferEncoding) {
        return new IEncodingAwareDataSource(){

            public String getContentType() {
                return dataSource.getContentType();
            }

            public InputStream getInputStream() throws IOException {
                return dataSource.getInputStream();
            }

            public String getName() {
                return dataSource.getName();
            }

            public OutputStream getOutputStream() throws IOException {
                return dataSource.getOutputStream();
            }

            @Override
            @Nullable
            public IContentTransferEncoding getContentTransferEncoding() {
                return iContentTransferEncoding;
            }
        };
    }
}

