/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.mime.IMimeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class ResponseHandlerString
implements HttpClientResponseHandler<String> {
    private final ContentType m_aDefault;
    private Charset m_aFallbackCharset;
    private Consumer<Charset> m_aCharsetConsumer;

    public ResponseHandlerString(@Nonnull IMimeType iMimeType, @Nonnull Charset charset) {
        this(ContentType.create((String)iMimeType.getAsString(), (Charset)charset));
    }

    public ResponseHandlerString(@Nonnull ContentType contentType) {
        ValueEnforcer.notNull((Object)contentType, (String)"Default");
        ValueEnforcer.notNull((Object)contentType.getCharset(), (String)"DefaultContentType.Charset");
        this.m_aDefault = contentType;
        this.m_aFallbackCharset = contentType.getCharset();
    }

    @Nonnull
    public final ContentType getDefaultContentType() {
        return this.m_aDefault;
    }

    @Nonnull
    public final Charset getDefaultCharset() {
        return this.m_aDefault.getCharset();
    }

    @Nonnull
    public final Charset getFallbackCharset() {
        return this.m_aFallbackCharset;
    }

    @Nonnull
    public final ResponseHandlerString setFallbackCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        this.m_aFallbackCharset = charset;
        return this;
    }

    @Nullable
    public final Consumer<Charset> getCharsetConsumer() {
        return this.m_aCharsetConsumer;
    }

    @Nonnull
    public final ResponseHandlerString setCharsetConsumer(@Nullable Consumer<Charset> consumer) {
        this.m_aCharsetConsumer = consumer;
        return this;
    }

    @Nullable
    public String handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
        if (httpEntity == null) {
            return null;
        }
        ContentType contentType = HttpClientHelper.getContentTypeOrDefault(httpEntity, this.m_aDefault);
        Charset charset = HttpClientHelper.getCharset(contentType, this.m_aFallbackCharset);
        if (this.m_aCharsetConsumer != null) {
            this.m_aCharsetConsumer.accept(charset);
        }
        return HttpClientHelper.entityToString(httpEntity, charset);
    }
}

