/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@NotThreadSafe
public class PSName
implements IPSClonableElement<PSName>,
IPSHasForeignAttributes {
    private String m_sPath;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Nullable
    public String getPath() {
        return this.m_sPath;
    }

    public boolean hasPath() {
        return this.m_sPath != null;
    }

    public void setPath(@Nullable String string) {
        this.m_sPath = string;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "name");
        microElement.setAttribute("path", this.m_sPath);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSName getClone() {
        PSName pSName = new PSName();
        pSName.setPath(this.m_sPath);
        if (this.hasForeignAttributes()) {
            pSName.addForeignAttributes((Map)this.m_aForeignAttrs);
        }
        return pSName;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("path", (Object)this.m_sPath).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }

    @Nonnull
    public static PSName ofPath(@Nullable String string) {
        PSName pSName = new PSName();
        pSName.setPath(string);
        return pSName;
    }
}

