/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.cache.impl.Cache;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.bound.PSBoundSchemaCacheKey;
import jakarta.annotation.Nonnull;

public class PSBoundSchemaCache
extends Cache<PSBoundSchemaCacheKey, IPSBoundSchema> {
    private PSBoundSchemaCache() {
        this(PSBoundSchemaCache.class.getName());
    }

    public PSBoundSchemaCache(@Nonnull String string) {
        super(pSBoundSchemaCacheKey -> {
            ValueEnforcer.notNull((Object)pSBoundSchemaCacheKey, (String)"Key");
            try {
                return pSBoundSchemaCacheKey.createBoundSchema();
            }
            catch (SchematronException schematronException) {
                throw new IllegalArgumentException(schematronException);
            }
        }, -1, string);
    }

    @Nonnull
    public static PSBoundSchemaCache getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final class SingletonHolder {
        static final PSBoundSchemaCache INSTANCE = new PSBoundSchemaCache();

        private SingletonHolder() {
        }
    }
}

