/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding.xpath;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringReplace;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.ICommonsNavigableMap;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundSchema;
import com.helger.schematron.pure.errorhandler.CollectingPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.PSParam;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.preprocess.PSPreprocessor;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.text.compare.ComparatorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSXPathQueryBinding
implements IPSQueryBinding {
    public static final char PARAM_VARIABLE_PREFIX = '$';
    private static final Logger LOGGER = LoggerFactory.getLogger(PSXPathQueryBinding.class);
    private static final PSXPathQueryBinding INSTANCE = new PSXPathQueryBinding();

    protected PSXPathQueryBinding() {
    }

    @Nonnull
    public static PSXPathQueryBinding getInstance() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public String getNegatedTestExpression(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Test");
        if (string.startsWith("not(") && string.endsWith(")")) {
            return string.substring(4, string.length() - 2);
        }
        return "not(" + string + ")";
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsNavigableMap<String, String> getStringReplacementMap(@Nonnull List<PSParam> list) {
        CommonsTreeMap commonsTreeMap = new CommonsTreeMap((Comparator)ComparatorHelper.getComparatorStringLongestFirst());
        for (PSParam pSParam : list) {
            commonsTreeMap.put((Object)("$" + pSParam.getName()), (Object)pSParam.getValue());
        }
        return commonsTreeMap;
    }

    @Nullable
    public static String getWithParamTextsReplacedStatic(@Nullable String string, @Nullable Map<String, String> map) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        String string2 = StringReplace.replaceMultiple((String)string, map);
        return string2;
    }

    @Override
    @Nullable
    public String getWithParamTextsReplaced(@Nullable String string, @Nullable Map<String, String> map) {
        return PSXPathQueryBinding.getWithParamTextsReplacedStatic(string, map);
    }

    @Override
    @Nonnull
    public IPSBoundSchema bind(@Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable IPSValidationHandler iPSValidationHandler, @Nullable IXPathConfig iXPathConfig) throws SchematronException {
        Object object;
        PSSchema pSSchema2;
        IPSErrorHandler iPSErrorHandler2;
        ValueEnforcer.notNull((Object)pSSchema, (String)"Schema");
        IPSErrorHandler iPSErrorHandler3 = iPSErrorHandler2 = iPSErrorHandler != null ? iPSErrorHandler : new CollectingPSErrorHandler();
        if (!pSSchema.isValid(iPSErrorHandler2)) {
            throw new SchematronBindException("The passed schema is not valid and can therefore not be bound" + (String)(iPSErrorHandler2 == iPSErrorHandler ? ". Errors are in the provided error handler." : ": " + ((CollectingPSErrorHandler)iPSErrorHandler2).getErrorList().toString()));
        }
        if (pSSchema.isPreprocessed()) {
            pSSchema2 = pSSchema;
        } else {
            object = PSPreprocessor.createPreprocessorWithoutInformationLoss(this);
            pSSchema2 = ((PSPreprocessor)object).getForcedPreprocessedSchema(pSSchema);
        }
        object = new PSXPathBoundSchema(this, pSSchema2, string, iPSErrorHandler, iPSValidationHandler, iXPathConfig);
        ((PSXPathBoundSchema)object).bind();
        return object;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

