/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.iterate.IterableIterator;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.schematron.pure.xpath.XPathFunctionFromUserFunction;
import com.helger.xml.xpath.MapBasedXPathFunctionResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.xml.xpath.XPathFunction;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQueryAsXPathFunctionConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XQueryAsXPathFunctionConverter.class);
    private final String m_sBaseURL;

    public XQueryAsXPathFunctionConverter() throws MalformedURLException {
        this(new File(""));
    }

    public XQueryAsXPathFunctionConverter(@Nonnull File file) throws MalformedURLException {
        this(FileHelper.getAsURLString((File)file));
    }

    public XQueryAsXPathFunctionConverter(@Nonnull @Nonempty String string) {
        this.m_sBaseURL = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseURL");
    }

    @Nonnull
    @Nonempty
    public String getBaseURL() {
        return this.m_sBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MapBasedXPathFunctionResolver loadXQuery(@Nonnull @WillClose InputStream inputStream) throws XPathException, IOException {
        ValueEnforcer.notNull((Object)inputStream, (String)"XQueryIS");
        try {
            MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = new MapBasedXPathFunctionResolver();
            Configuration configuration = new Configuration();
            DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(configuration);
            StaticQueryContext staticQueryContext = configuration.newStaticQueryContext();
            staticQueryContext.setBaseURI(this.m_sBaseURL);
            String string = null;
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(inputStream, string);
            Controller controller = xQueryExpression.newController(dynamicQueryContext);
            FunctionLibraryList functionLibraryList = xQueryExpression.getExecutable().getFunctionLibrary();
            for (FunctionLibrary functionLibrary : functionLibraryList.getLibraryList()) {
                ExecutableFunctionLibrary executableFunctionLibrary;
                FunctionLibraryList functionLibraryList2;
                if (functionLibrary instanceof FunctionLibraryList) {
                    functionLibraryList2 = (FunctionLibraryList)functionLibrary;
                    for (FunctionLibrary functionLibrary2 : functionLibraryList2.getLibraryList()) {
                        if (functionLibrary2 instanceof ExecutableFunctionLibrary) {
                            executableFunctionLibrary = (ExecutableFunctionLibrary)functionLibrary2;
                            for (UserFunction userFunction : new IterableIterator(executableFunctionLibrary.getAllFunctions())) {
                                StructuredQName structuredQName = userFunction.getFunctionName();
                                mapBasedXPathFunctionResolver.addUniqueFunction(structuredQName.getNamespaceBinding().getNamespaceUri().toString(), structuredQName.getLocalPart(), userFunction.getArity(), (XPathFunction)new XPathFunctionFromUserFunction(configuration, controller, userFunction));
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug("Registered user function '" + structuredQName.getNamespaceBinding().getPrefix() + ":" + structuredQName.getLocalPart() + "' with arity of " + userFunction.getArity());
                            }
                            continue;
                        }
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Ignoring other nested function library of type " + functionLibrary2.getClass().getName());
                    }
                    continue;
                }
                if (functionLibrary instanceof XQueryFunctionLibrary) {
                    functionLibraryList2 = (XQueryFunctionLibrary)functionLibrary;
                    for (FunctionLibrary functionLibrary2 : new IterableIterator(functionLibraryList2.getFunctionDefinitions())) {
                        functionLibrary2.compile();
                        executableFunctionLibrary = functionLibrary2.getFunctionName();
                        mapBasedXPathFunctionResolver.addUniqueFunction(executableFunctionLibrary.getNamespaceBinding().getNamespaceUri().toString(), executableFunctionLibrary.getLocalPart(), functionLibrary2.getNumberOfParameters(), (XPathFunction)new XPathFunctionFromUserFunction(configuration, controller, functionLibrary2.getUserFunction()));
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Registered user function '" + executableFunctionLibrary.getNamespaceBinding().getPrefix() + ":" + executableFunctionLibrary.getLocalPart() + "' with arity of " + functionLibrary2.getNumberOfParameters());
                    }
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Ignoring other function library of type " + functionLibrary.getClass().getName());
            }
            MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver2 = mapBasedXPathFunctionResolver;
            return mapBasedXPathFunctionResolver2;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }
}

