/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class XPathLetVariableResolver
implements XPathVariableResolver {
    private final ICommonsMap<QName, Object> m_aVariables = new CommonsHashMap();
    private final XPathVariableResolver m_aDelegatedResolver;

    public XPathLetVariableResolver(@Nullable XPathVariableResolver xPathVariableResolver) {
        this.m_aDelegatedResolver = xPathVariableResolver;
    }

    public void setVariableValue(@Nonnull QName qName, @Nullable Object object) {
        ValueEnforcer.notNull((Object)qName, (String)"VariableName");
        this.m_aVariables.put((Object)qName, object);
    }

    public void removeVariable(@Nullable QName qName) {
        if (qName != null) {
            this.m_aVariables.remove((Object)qName);
        }
    }

    @Override
    public Object resolveVariable(@Nullable QName qName) {
        if (qName != null) {
            Object object = this.m_aVariables.get((Object)qName);
            if (object != null) {
                return object;
            }
            if (this.m_aDelegatedResolver != null) {
                return this.m_aDelegatedResolver.resolveVariable(qName);
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Variables", this.m_aVariables).append("DelegatedResolver", (Object)this.m_aDelegatedResolver).getToString();
    }
}

