/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronException;
import com.helger.schematron.SchematronInterruptedException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.PSQueryBindingRegistry;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.exchange.PSReader;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.preprocess.PSPreprocessor;
import com.helger.schematron.pure.preprocess.SchematronPreprocessException;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

@Immutable
public class PSBoundSchemaCacheKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSBoundSchemaCacheKey.class);
    private final IReadableResource m_aResource;
    private final String m_sPhase;
    private final IPSErrorHandler m_aErrorHandler;
    private final IPSValidationHandler m_aCustomValidationHandler;
    private final IXPathConfig m_aXPathConfig;
    private final EntityResolver m_aEntityResolver;
    private final boolean m_bLenient;
    private int m_nHashCode = 0;

    public PSBoundSchemaCacheKey(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable IPSValidationHandler iPSValidationHandler, @Nonnull IXPathConfig iXPathConfig, @Nullable EntityResolver entityResolver, boolean bl) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)iXPathConfig, (String)"XPathConfig");
        this.m_aResource = iReadableResource;
        this.m_sPhase = string;
        this.m_aErrorHandler = iPSErrorHandler;
        this.m_aCustomValidationHandler = iPSValidationHandler;
        this.m_aXPathConfig = iXPathConfig;
        this.m_aEntityResolver = entityResolver;
        this.m_bLenient = bl;
    }

    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    @Nullable
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nullable
    public final IPSValidationHandler getCustomValidationHandler() {
        return this.m_aCustomValidationHandler;
    }

    @Nonnull
    public final IXPathConfig getXPathConfig() {
        return this.m_aXPathConfig;
    }

    @Nullable
    public final EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    public final boolean isLenient() {
        return this.m_bLenient;
    }

    @Nonnull
    @OverrideOnDemand
    public PSSchema readSchema(@Nonnull IReadableResource iReadableResource, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable EntityResolver entityResolver) throws SchematronException {
        return new PSReader(iReadableResource, iPSErrorHandler, entityResolver).setLenient(this.isLenient()).readSchema();
    }

    @Nonnull
    @OverrideOnDemand
    public IPSQueryBinding getQueryBinding(@Nonnull PSSchema pSSchema) throws SchematronException {
        return PSQueryBindingRegistry.getQueryBindingOfNameOrThrow(pSSchema.getQueryBinding());
    }

    @Nonnull
    @OverrideOnDemand
    public PSPreprocessor createPreprocessor(@Nonnull IPSQueryBinding iPSQueryBinding) {
        return PSPreprocessor.createPreprocessorWithoutInformationLoss(iPSQueryBinding);
    }

    @Nonnull
    @OverrideOnDemand
    public PSSchema createPreprocessedSchema(@Nonnull PSSchema pSSchema, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronException {
        PSPreprocessor pSPreprocessor = this.createPreprocessor(iPSQueryBinding);
        PSSchema pSSchema2 = pSPreprocessor.getAsPreprocessedSchema(pSSchema);
        if (pSSchema2 == null) {
            throw new SchematronPreprocessException("Failed to preprocess schema " + pSSchema + " with query binding " + iPSQueryBinding);
        }
        if (SchematronDebug.isShowPreprocessedSchematron()) {
            LOGGER.info("Preprocessed Schematron:\n" + MicroWriter.getNodeAsString((IMicroNode)pSSchema2.getAsMicroElement()));
        }
        return pSSchema2;
    }

    @Nonnull
    public IPSBoundSchema createBoundSchema() throws SchematronException {
        PSSchema pSSchema = this.readSchema(this.getResource(), this.getErrorHandler(), this.getEntityResolver());
        IPSQueryBinding iPSQueryBinding = this.getQueryBinding(pSSchema);
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("Schematron creation interrupted before preprocessing");
        }
        PSSchema pSSchema2 = this.createPreprocessedSchema(pSSchema, iPSQueryBinding);
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("Schematron creation interrupted after preprocessing");
        }
        IPSBoundSchema iPSBoundSchema = iPSQueryBinding.bind(pSSchema2, this.m_sPhase, this.m_aErrorHandler, this.m_aCustomValidationHandler, this.m_aXPathConfig);
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("Schematron creation interrupted after binding");
        }
        return iPSBoundSchema;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PSBoundSchemaCacheKey pSBoundSchemaCacheKey = (PSBoundSchemaCacheKey)object;
        return this.m_aResource.equals(pSBoundSchemaCacheKey.m_aResource) && EqualsHelper.equals((Object)this.m_sPhase, (Object)pSBoundSchemaCacheKey.m_sPhase) && EqualsHelper.equals((Object)this.m_aXPathConfig, (Object)pSBoundSchemaCacheKey.m_aXPathConfig);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_aResource).append((Object)this.m_sPhase).append((Object)this.m_aXPathConfig).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Resource", (Object)this.m_aResource).append("Phase", (Object)this.m_sPhase).appendIfNotNull("ErrorHandler", (Object)this.m_aErrorHandler).appendIfNotNull("CustomValidationHandler", (Object)this.m_aCustomValidationHandler).appendIfNotNull("XPathConfig", (Object)this.m_aXPathConfig).appendIfNotNull("EntityResolver", (Object)this.m_aEntityResolver).append("Lenient", this.m_bLenient).getToString();
    }
}

