/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.commons.io.resource.inmemory.ReadableResourceInputStream;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.state.EValidity;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronException;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.bound.PSBoundSchemaCache;
import com.helger.schematron.pure.bound.PSBoundSchemaCacheKey;
import com.helger.schematron.pure.errorhandler.DoNothingPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.exchange.PSWriter;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.xpath.IXPathConfig;
import com.helger.schematron.pure.xpath.XPathConfigBuilder;
import com.helger.schematron.svrl.SVRLMarshaller;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public class SchematronResourcePure
extends AbstractSchematronResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourcePure.class);
    private String m_sPhase;
    private IPSErrorHandler m_aErrorHandler;
    private IPSValidationHandler m_aCustomValidationHandler;
    private IXPathConfig m_aXPathConfig = XPathConfigBuilder.DEFAULT;
    private IPSBoundSchema m_aBoundSchema;

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) {
        super(iReadableResource);
        this.setPhase(string);
        this.setErrorHandler(iPSErrorHandler);
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    @Nonnull
    public final SchematronResourcePure setPhase(@Nullable String string) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_sPhase = string;
        return this;
    }

    @Nullable
    public final IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    public final SchematronResourcePure setErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aErrorHandler = iPSErrorHandler;
        return this;
    }

    @Nullable
    public final IPSValidationHandler getCustomValidationHandler() {
        return this.m_aCustomValidationHandler;
    }

    @Nonnull
    public final SchematronResourcePure setCustomValidationHandler(@Nullable IPSValidationHandler iPSValidationHandler) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aCustomValidationHandler = iPSValidationHandler;
        return this;
    }

    @Nonnull
    public final IXPathConfig getXPathConfig() {
        return this.m_aXPathConfig;
    }

    @Nonnull
    public final SchematronResourcePure setXPathConfig(@Nonnull IXPathConfig iXPathConfig) {
        ValueEnforcer.notNull((Object)iXPathConfig, (String)"XPathConfig");
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aXPathConfig = iXPathConfig;
        return this;
    }

    @Nonnull
    public SchematronResourcePure setEntityResolver(@Nullable EntityResolver entityResolver) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.internalSetEntityResolver(entityResolver);
        return this;
    }

    @Nonnull
    protected IPSBoundSchema createBoundSchema() {
        IReadableResource iReadableResource = this.getResource();
        PSBoundSchemaCacheKey pSBoundSchemaCacheKey = new PSBoundSchemaCacheKey(iReadableResource, this.m_sPhase, this.m_aErrorHandler, this.m_aCustomValidationHandler, this.m_aXPathConfig, this.getEntityResolver(), this.isLenient());
        if (iReadableResource instanceof AbstractMemoryReadableResource || !this.isUseCache()) {
            try {
                return pSBoundSchemaCacheKey.createBoundSchema();
            }
            catch (SchematronException schematronException) {
                throw new IllegalStateException("Failed to bind Schematron", schematronException);
            }
        }
        return (IPSBoundSchema)PSBoundSchemaCache.getInstance().getFromCache(pSBoundSchemaCacheKey);
    }

    @Nonnull
    public IPSBoundSchema getOrCreateBoundSchema() {
        if (this.m_aBoundSchema == null) {
            try {
                this.m_aBoundSchema = this.createBoundSchema();
            }
            catch (RuntimeException runtimeException) {
                if (this.m_aErrorHandler != null) {
                    this.m_aErrorHandler.handleError((IError)((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorLocation((ILocation)new SimpleLocation(this.getResource().getPath()))).errorText("Error creating bound schema")).linkedException((Throwable)runtimeException)).build());
                }
                throw runtimeException;
            }
        }
        return this.m_aBoundSchema;
    }

    public boolean isValidSchematron() {
        try {
            IPSErrorHandler iPSErrorHandler = this.m_aErrorHandler != null ? this.m_aErrorHandler : new DoNothingPSErrorHandler();
            return this.getOrCreateBoundSchema().getOriginalSchema().isValid(iPSErrorHandler);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public void validateCompletely() {
        IPSErrorHandler iPSErrorHandler = this.m_aErrorHandler != null ? this.m_aErrorHandler : new DoNothingPSErrorHandler();
        this.validateCompletely(iPSErrorHandler);
    }

    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        ValueEnforcer.notNull((Object)iPSErrorHandler, (String)"ErrorHandler");
        try {
            this.getOrCreateBoundSchema().getOriginalSchema().validateCompletely(iPSErrorHandler);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Node node, @Nullable String string) throws Exception {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        if (!this.isValidSchematron()) {
            return EValidity.INVALID;
        }
        return this.getOrCreateBoundSchema().validatePartially(node, string);
    }

    @Nonnull
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Node node, @Nullable String string) throws SchematronException {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        SchematronOutputType schematronOutputType = this.getOrCreateBoundSchema().validateComplete(node, string);
        if (SchematronDebug.isShowCreatedSVRL()) {
            LOGGER.info("Created SVRL:\n" + new SVRLMarshaller(false).getAsString((Object)schematronOutputType));
        }
        return schematronOutputType;
    }

    @Nullable
    public Document applySchematronValidation(@Nonnull Node node, @Nullable String string) throws Exception {
        ValueEnforcer.notNull((Object)node, (String)"XMLNode");
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(node, string);
        return new SVRLMarshaller().getAsDocument((Object)schematronOutputType);
    }

    @Nonnull
    public static SchematronResourcePure fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromClassPath(@Nonnull @Nonempty String string, @Nullable ClassLoader classLoader) {
        return new SchematronResourcePure((IReadableResource)new ClassPathResource(string, classLoader));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull File file) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public static SchematronResourcePure fromURL(@Nonnull @Nonempty String string) throws MalformedURLException {
        return new SchematronResourcePure((IReadableResource)new URLResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromURL(@Nonnull URL uRL) {
        return new SchematronResourcePure((IReadableResource)new URLResource(uRL));
    }

    @Nonnull
    public static SchematronResourcePure fromInputStream(@Nonnull @Nonempty String string, @Nonnull InputStream inputStream) {
        return new SchematronResourcePure((IReadableResource)new ReadableResourceInputStream(string, inputStream));
    }

    @Nonnull
    public static SchematronResourcePure fromByteArray(@Nonnull byte[] byArray) {
        return new SchematronResourcePure((IReadableResource)new ReadableResourceByteArray(byArray));
    }

    @Nonnull
    public static SchematronResourcePure fromString(@Nonnull String string, @Nonnull Charset charset) {
        return SchematronResourcePure.fromByteArray(string.getBytes(charset));
    }

    @Nonnull
    public static SchematronResourcePure fromSchema(@Nonnull PSSchema pSSchema) {
        return SchematronResourcePure.fromString(new PSWriter().getXMLString(pSSchema), XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ);
    }
}

