/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.schematron.svrl.ISVRLLocationBeautifierSPI;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class SVRLLocationBeautifierRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVRLLocationBeautifierRegistry.class);
    private static final List<ISVRLLocationBeautifierSPI> LIST = ServiceLoaderHelper.getAllSPIImplementations(ISVRLLocationBeautifierSPI.class);
    private static final SVRLLocationBeautifierRegistry INSTANCE = new SVRLLocationBeautifierRegistry();

    private SVRLLocationBeautifierRegistry() {
    }

    public static @Nullable String getBeautifiedLocation(@NonNull String string, @NonNull String string2) {
        for (ISVRLLocationBeautifierSPI iSVRLLocationBeautifierSPI : LIST) {
            String string3 = iSVRLLocationBeautifierSPI.getReplacementText(string, string2);
            if (string3 == null) continue;
            return string3;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unsupported elements for beautification: " + string + " -- " + string2);
        }
        return null;
    }
}

