/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.resolve;

import com.helger.annotation.Nonempty;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceresolver.DefaultResourceResolver;
import com.helger.schematron.resolve.ISchematronIncludeResolver;
import java.io.IOException;
import java.net.URL;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultSchematronIncludeResolver
implements ISchematronIncludeResolver {
    private final String m_sBaseHref;
    private ISchematronIncludeResolver m_aCustomIncludeResolver;

    private static @Nullable String _getBaseHref(@NonNull IReadableResource iReadableResource) {
        URL uRL = iReadableResource.getAsURL();
        return uRL == null ? null : uRL.toExternalForm();
    }

    public DefaultSchematronIncludeResolver(@NonNull IReadableResource iReadableResource) {
        this(DefaultSchematronIncludeResolver._getBaseHref(iReadableResource));
    }

    public DefaultSchematronIncludeResolver(@Nullable String string) {
        this.m_sBaseHref = string;
    }

    public final @Nullable String getBaseHref() {
        return this.m_sBaseHref;
    }

    public void setCustomSchematronIncludeResolver(@Nullable ISchematronIncludeResolver iSchematronIncludeResolver) {
        this.m_aCustomIncludeResolver = iSchematronIncludeResolver;
    }

    @Override
    public @NonNull IReadableResource getResolvedSchematronResource(@Nonempty @NonNull String string) throws IOException {
        IReadableResource iReadableResource;
        if (this.m_aCustomIncludeResolver != null && (iReadableResource = this.m_aCustomIncludeResolver.getResolvedSchematronResource(string)) != null) {
            return iReadableResource;
        }
        return DefaultResourceResolver.getResolvedResource((String)string, (String)this.getBaseHref());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseHref", (Object)this.m_sBaseHref).appendIfNotNull("CustomIncludeResolver", (Object)this.m_aCustomIncludeResolver).getToString();
    }
}

