/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.trigger;

import com.helger.base.reflection.GenericReflection;
import com.helger.datetime.helper.PDTFactory;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IMutableTrigger;
import com.helger.quartz.utils.Key;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Map;

public class JDK8TriggerBuilder<T extends ITrigger> {
    private TriggerKey m_aTriggerKey;
    private String m_sDescription;
    private LocalDateTime m_aStartTime = PDTFactory.getCurrentLocalDateTime();
    private LocalDateTime m_aEndTime;
    private int m_nPriority = 5;
    private String m_sCalendarName;
    private JobKey m_aJobKey;
    private JobDataMap m_aJobDataMap = new JobDataMap();
    private IScheduleBuilder<? extends ITrigger> m_aScheduleBuilder;

    protected JDK8TriggerBuilder() {
    }

    @Nonnull
    public static JDK8TriggerBuilder<ITrigger> newTrigger() {
        return new JDK8TriggerBuilder<ITrigger>();
    }

    @Nonnull
    public T build() {
        if (this.m_aScheduleBuilder == null) {
            this.m_aScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        }
        IMutableTrigger iMutableTrigger = this.m_aScheduleBuilder.build();
        iMutableTrigger.setCalendarName(this.m_sCalendarName);
        iMutableTrigger.setDescription(this.m_sDescription);
        iMutableTrigger.setStartTime(PDTFactory.createDate((LocalDateTime)this.m_aStartTime));
        iMutableTrigger.setEndTime(PDTFactory.createDate((LocalDateTime)this.m_aEndTime));
        if (this.m_aTriggerKey == null) {
            this.m_aTriggerKey = new TriggerKey(Key.createUniqueName(null), null);
        }
        iMutableTrigger.setKey(this.m_aTriggerKey);
        if (this.m_aJobKey != null) {
            iMutableTrigger.setJobKey(this.m_aJobKey);
        }
        iMutableTrigger.setPriority(this.m_nPriority);
        if (!this.m_aJobDataMap.isEmpty()) {
            iMutableTrigger.setJobDataMap(this.m_aJobDataMap);
        }
        return (T)((ITrigger)GenericReflection.uncheckedCast((Object)iMutableTrigger));
    }

    @Nonnull
    public JDK8TriggerBuilder<T> withIdentity(String string) {
        this.m_aTriggerKey = new TriggerKey(string, null);
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> withIdentity(String string, String string2) {
        this.m_aTriggerKey = new TriggerKey(string, string2);
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> withIdentity(TriggerKey triggerKey) {
        this.m_aTriggerKey = triggerKey;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> withDescription(String string) {
        this.m_sDescription = string;
        return this;
    }

    public JDK8TriggerBuilder<T> withPriority(int n) {
        this.m_nPriority = n;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> modifiedByCalendar(String string) {
        this.m_sCalendarName = string;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> startAt(LocalDateTime localDateTime) {
        this.m_aStartTime = localDateTime;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> startNow() {
        return this.startAt(PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    public JDK8TriggerBuilder<T> endAt(LocalDateTime localDateTime) {
        this.m_aEndTime = localDateTime;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> withSchedule(IScheduleBuilder<? extends T> iScheduleBuilder) {
        this.m_aScheduleBuilder = iScheduleBuilder;
        return this;
    }

    public JDK8TriggerBuilder<T> forJob(JobKey jobKey) {
        this.m_aJobKey = jobKey;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> forJob(String string) {
        this.m_aJobKey = new JobKey(string, null);
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> forJob(String string, String string2) {
        this.m_aJobKey = new JobKey(string, string2);
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> forJob(IJobDetail iJobDetail) {
        JobKey jobKey = iJobDetail.getKey();
        if (jobKey.getName() == null) {
            throw new IllegalArgumentException("The given job has not yet had a name assigned to it.");
        }
        this.m_aJobKey = jobKey;
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, Object object) {
        this.m_aJobDataMap.put((Object)string, object);
        return this;
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, int n) {
        return this.usingJobData(string, (Object)n);
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, long l) {
        return this.usingJobData(string, (Object)l);
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, float f) {
        return this.usingJobData(string, Float.valueOf(f));
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, double d) {
        return this.usingJobData(string, (Object)d);
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(String string, boolean bl) {
        return this.usingJobData(string, (Object)bl);
    }

    @Nonnull
    public JDK8TriggerBuilder<T> usingJobData(@Nonnull JobDataMap jobDataMap) {
        jobDataMap.putAll((Map)this.m_aJobDataMap);
        this.m_aJobDataMap = jobDataMap;
        return this;
    }
}

