/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.jobstore;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.JobKey;
import jakarta.annotation.Nonnull;

@Immutable
final class JobWrapper {
    private final JobKey m_aKey;
    private IJobDetail m_aJobDetail;

    JobWrapper(@Nonnull IJobDetail iJobDetail) {
        this.m_aKey = iJobDetail.getKey();
        this.setJobDetail(iJobDetail);
    }

    @Nonnull
    public JobKey getJobKey() {
        return this.m_aKey;
    }

    @Nonnull
    public IJobDetail getJobDetail() {
        return this.m_aJobDetail;
    }

    public void setJobDetail(@Nonnull IJobDetail iJobDetail) {
        ValueEnforcer.notNull((Object)iJobDetail, (String)"JobDetail");
        ValueEnforcer.isTrue((boolean)iJobDetail.getKey().equals((Object)this.m_aKey), (String)"Different JobKey!");
        this.m_aJobDetail = iJobDetail;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JobWrapper jobWrapper = (JobWrapper)object;
        return this.m_aKey.equals((Object)jobWrapper.m_aKey);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aKey).getHashCode();
    }
}

